/*
 * Decompiled with CFR 0.152.
 */
package io.jschneider.graphql.gremlin.entity;

import io.jschneider.graphql.gremlin.directive.GraphQLDirectiveAware;
import io.jschneider.graphql.gremlin.entity.GraphQLFragmentEntity;
import io.jschneider.graphql.gremlin.entity.GraphQLRelationEntity;
import io.jschneider.graphql.gremlin.field.GraphQLField;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public interface GraphQLEntity
extends GraphQLDirectiveAware {
    public List<GraphQLField> getFields();

    public List<GraphQLEntity> getChildEntities();

    default public List<GraphQLField> flattenedFields() {
        ArrayList<GraphQLField> fieldsIncludingFragments = new ArrayList<GraphQLField>(this.getFields());
        fieldsIncludingFragments.addAll(this.getChildEntities().stream().filter(c -> c instanceof GraphQLFragmentEntity).flatMap(c -> c.flattenedFields().stream()).collect(Collectors.toList()));
        return fieldsIncludingFragments;
    }

    default public List<GraphQLRelationEntity> flattenedChildEntities() {
        List<GraphQLRelationEntity> children = this.getChildEntities().stream().filter(c -> c instanceof GraphQLRelationEntity).filter(c -> !c.isSkipped()).map(c -> (GraphQLRelationEntity)c).collect(Collectors.toList());
        children.addAll(this.getChildEntities().stream().filter(c -> c instanceof GraphQLFragmentEntity).filter(c -> !c.isSkipped()).flatMap(c -> c.flattenedChildEntities().stream()).collect(Collectors.toList()));
        return children;
    }
}

