/*
 * Decompiled with CFR 0.152.
 */
package io.jschneider.graphql.gremlin;

import io.jschneider.graphql.gremlin.GraphQLCompilerListener;
import io.jschneider.graphql.gremlin.grammar.GraphQLLexer;
import io.jschneider.graphql.gremlin.grammar.GraphQLParser;
import io.jschneider.graphql.gremlin.variable.VariableResolver;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class GraphQLToGremlinCompiler {
    private GraphTraversal<Vertex, ?> traversal;

    private GraphQLToGremlinCompiler(GraphTraversal<Vertex, ?> traversal) {
        this.traversal = traversal;
    }

    public static GraphTraversal<Vertex, ?> convertToGremlinTraversal(Graph g, VariableResolver variableResolver, String query) {
        return new GraphQLToGremlinCompiler(g.traversal().V(new Object[0])).convertToGremlinTraversal(query, variableResolver);
    }

    public static GraphTraversal<Vertex, ?> convertToGremlinTraversal(GraphTraversalSource gts, VariableResolver variableResolver, String query) {
        return new GraphQLToGremlinCompiler(gts.V(new Object[0])).convertToGremlinTraversal(query, variableResolver);
    }

    GraphTraversal<Vertex, ?> convertToGremlinTraversal(String graphql, VariableResolver variableResolver) {
        GraphQLLexer lexer = new GraphQLLexer((CharStream)new ANTLRInputStream(graphql));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GraphQLParser parser = new GraphQLParser((TokenStream)tokens);
        GraphQLParser.DocumentContext tree = parser.document();
        GraphQLCompilerListener listener = new GraphQLCompilerListener(this.traversal, variableResolver);
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        return listener.result();
    }
}

