/*
 * Decompiled with CFR 0.152.
 */
package io.jschneider.graphql.gremlin;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import io.jschneider.graphql.gremlin.directive.GraphQLDirectiveAware;
import io.jschneider.graphql.gremlin.directive.SkipDirective;
import io.jschneider.graphql.gremlin.entity.GraphQLEntity;
import io.jschneider.graphql.gremlin.entity.GraphQLEntitySelectStep;
import io.jschneider.graphql.gremlin.entity.GraphQLFragmentEntity;
import io.jschneider.graphql.gremlin.entity.GraphQLRelationEntity;
import io.jschneider.graphql.gremlin.field.GraphQLField;
import io.jschneider.graphql.gremlin.grammar.GraphQLBaseListener;
import io.jschneider.graphql.gremlin.grammar.GraphQLParser;
import io.jschneider.graphql.gremlin.variable.GraphQLValue;
import io.jschneider.graphql.gremlin.variable.GraphQLValueOrVariable;
import io.jschneider.graphql.gremlin.variable.GraphQLVariable;
import io.jschneider.graphql.gremlin.variable.VariableResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class GraphQLCompilerListener
extends GraphQLBaseListener {
    private GraphTraversal<Vertex, ?> traversal;
    private VariableResolver variableResolver;
    private Multiset<String> asNames = TreeMultiset.create();
    private GraphQLRelationEntity queryEntity = new GraphQLRelationEntity("query", "query");
    private Stack<GraphQLEntity> entityStack = new Stack();
    private Map<String, GraphQLFragmentEntity> fragmentsByName = new HashMap<String, GraphQLFragmentEntity>();

    public GraphQLCompilerListener(GraphTraversal<Vertex, ?> traversal, VariableResolver variableResolver) {
        this.traversal = traversal;
        this.variableResolver = variableResolver;
    }

    public GraphTraversal<Vertex, ?> result() {
        return this.traversal;
    }

    @Override
    public void enterDocument(@NotNull GraphQLParser.DocumentContext ctx) {
        this.entityStack.push(this.queryEntity);
    }

    @Override
    public void enterOperationType(@NotNull GraphQLParser.OperationTypeContext ctx) {
        if (ctx.getText().equals("mutation")) {
            throw new UnsupportedOperationException("GraphQL mutation is not supported");
        }
    }

    @Override
    public void enterFragmentDefinition(@NotNull GraphQLParser.FragmentDefinitionContext ctx) {
        GraphQLFragmentEntity fragment = this.fragmentsByName.computeIfAbsent(ctx.fragmentName().getText(), GraphQLFragmentEntity::new);
        GraphQLParser.TypeNameContext typeName = ctx.typeCondition().typeName();
        if (typeName != null) {
            fragment.setType(typeName.getText());
        }
        this.addDirectives(fragment, ctx.directives());
        this.entityStack.push(fragment);
    }

    @Override
    public void exitFragmentDefinition(@NotNull GraphQLParser.FragmentDefinitionContext ctx) {
        this.entityStack.pop();
    }

    @Override
    public void enterFragmentSpread(@NotNull GraphQLParser.FragmentSpreadContext ctx) {
        GraphQLFragmentEntity fragment = this.fragmentsByName.computeIfAbsent(ctx.fragmentName().getText(), GraphQLFragmentEntity::new);
        this.addDirectives(fragment, ctx.directives());
        GraphQLEntity parentEntity = this.entityStack.peek();
        parentEntity.getChildEntities().add(fragment);
    }

    @Override
    public void enterInlineFragment(@NotNull GraphQLParser.InlineFragmentContext ctx) {
        String name = "inlineFragment" + this.asNames.count((Object)"inlineFragment");
        this.asNames.add((Object)"inlineFragment");
        GraphQLFragmentEntity fragment = this.fragmentsByName.computeIfAbsent(name, GraphQLFragmentEntity::new);
        this.addDirectives(fragment, ctx.directives());
        GraphQLEntity parentEntity = this.entityStack.peek();
        parentEntity.getChildEntities().add(fragment);
        this.entityStack.push(fragment);
    }

    @Override
    public void exitInlineFragment(@NotNull GraphQLParser.InlineFragmentContext ctx) {
        this.entityStack.pop();
    }

    @Override
    public void enterFieldRelation(@NotNull GraphQLParser.FieldRelationContext ctx) {
        String relationName = ctx.fieldName().getText();
        String relationAlias = relationName + this.asNames.count((Object)relationName);
        GraphQLRelationEntity entity = new GraphQLRelationEntity(relationName, relationAlias);
        GraphQLEntity parentEntity = this.entityStack.peek();
        parentEntity.getChildEntities().add(entity);
        for (GraphQLParser.ArgumentContext arg : ctx.arguments().argument()) {
            entity.getWhereClauses().add(this.valueOrVariable(arg));
        }
        this.addDirectives(entity, ctx.directives());
        this.entityStack.push(entity);
        this.asNames.add((Object)relationName);
    }

    private Object value(GraphQLParser.ValueContext valueContext) {
        String val = valueContext.getText().replaceAll("\"", "");
        if (valueContext instanceof GraphQLParser.StringValueContext) {
            return val;
        }
        if (valueContext instanceof GraphQLParser.BooleanValueContext) {
            return Boolean.parseBoolean(val);
        }
        if (valueContext instanceof GraphQLParser.NumberValueContext) {
            if (val.contains(".")) {
                return Double.parseDouble(val);
            }
            return Integer.parseInt(val);
        }
        return null;
    }

    private GraphQLValueOrVariable valueOrVariable(GraphQLParser.ArgumentContext ctx) {
        if (ctx == null) {
            return null;
        }
        String key = ctx.NAME().getText();
        if (ctx.valueOrVariable().value() != null) {
            return new GraphQLValue(key, this.value(ctx.valueOrVariable().value()));
        }
        return new GraphQLVariable(key, ctx.valueOrVariable().variable().NAME().getText(), this.variableResolver);
    }

    @Override
    public void exitFieldRelation(@NotNull GraphQLParser.FieldRelationContext ctx) {
        this.entityStack.pop();
    }

    @Override
    public void enterVariableDefinition(@NotNull GraphQLParser.VariableDefinitionContext ctx) {
        if (ctx.defaultValue() != null) {
            this.variableResolver.defaultValue(ctx.variable().NAME().getText(), this.value(ctx.defaultValue().value()));
        }
    }

    @Override
    public void enterFieldValue(@NotNull GraphQLParser.FieldValueContext ctx) {
        GraphQLParser.FieldNameContext fieldNameContext = ctx.fieldName();
        String fieldName = fieldNameContext.getText();
        String queryAlias = null;
        if (fieldNameContext.alias() != null) {
            List<TerminalNode> aliasParts = fieldNameContext.alias().NAME();
            fieldName = aliasParts.get(1).getText();
            queryAlias = aliasParts.get(0).getText();
        }
        String fieldAlias = fieldName + this.asNames.count((Object)fieldName);
        this.asNames.add((Object)fieldName);
        GraphQLField field = new GraphQLField(fieldName, fieldAlias, queryAlias);
        this.addDirectives(field, ctx.directives());
        this.entityStack.peek().getFields().add(field);
    }

    @Override
    public void exitDocument(@NotNull GraphQLParser.DocumentContext ctx) {
        Preconditions.checkState((this.entityStack.size() == 1 ? 1 : 0) != 0);
        this.recurseBuildMatch(this.queryEntity, null, this.traversal);
    }

    private GraphTraversal<?, ?> recurseBuildMatch(GraphQLRelationEntity entity, GraphQLRelationEntity parent, GraphTraversal<?, ?> at) {
        List<GraphQLField> fields = entity.flattenedFields();
        ArrayList matchClauses = new ArrayList(fields.size() + entity.getChildEntities().size() + 1);
        if (!entity.getWhereClauses().isEmpty()) {
            matchClauses.add(this.buildWhereClause(entity, parent));
        }
        matchClauses.addAll(fields.stream().filter(f -> !f.isSkipped()).map(field -> __.as((String)entity.getPrivateRelationAlias(), (String[])new String[0]).values(new String[]{field.getFieldName()}).as(field.getFieldAlias(), new String[0])).collect(Collectors.toList()));
        matchClauses.addAll(entity.flattenedChildEntities().stream().map(c -> this.recurseBuildMatch((GraphQLRelationEntity)c, entity, (GraphTraversal<?, ?>)__.as((String)entity.getPrivateRelationAlias(), (String[])new String[0]))).collect(Collectors.toList()));
        GraphTraversal match = at.match(matchClauses.toArray(new Traversal[matchClauses.size()]));
        match.asAdmin().addStep(new GraphQLEntitySelectStep((Traversal.Admin)match.asAdmin(), entity));
        if (!entity.getRelationAlias().equals(entity.getRelationName())) {
            match = match.as(entity.getRelationAlias(), new String[0]);
        }
        return match;
    }

    private GraphTraversal<?, ?> buildWhereClause(GraphQLRelationEntity entity, GraphQLRelationEntity parent) {
        GraphTraversal whereClause = parent == this.queryEntity ? this.buildHasChain(entity, __.as((String)parent.getRelationName(), (String[])new String[0]).barrier(1)) : __.as((String)parent.getPrivateRelationAlias(), (String[])new String[0]).union(new Traversal[]{this.buildHasChain(entity, __.outE((String[])new String[]{entity.getRelationName()})).inV(), this.buildHasChain(entity, __.out((String[])new String[]{entity.getRelationName()}))}).dedup(new String[0]);
        return whereClause.as(entity.getPrivateRelationAlias(), new String[0]);
    }

    private <E> GraphTraversal<?, E> buildHasChain(GraphQLRelationEntity entity, GraphTraversal<?, E> whereClause) {
        for (GraphQLValueOrVariable valueOrVariable : entity.getWhereClauses()) {
            whereClause = whereClause.has(valueOrVariable.getKey(), valueOrVariable.getValue());
        }
        return whereClause;
    }

    private void addDirectives(GraphQLDirectiveAware directiveAware, GraphQLParser.DirectivesContext ctx) {
        if (ctx != null) {
            for (GraphQLParser.DirectiveContext directiveContext : ctx.directive()) {
                String directiveName = directiveContext.NAME().getText();
                if ("skip".equals(directiveName)) {
                    directiveAware.getDirectives().add(new SkipDirective(this.valueOrVariable(directiveContext.argument()), false));
                    continue;
                }
                if (!"include".equals(directiveName)) continue;
                directiveAware.getDirectives().add(new SkipDirective(this.valueOrVariable(directiveContext.argument()), true));
            }
        }
    }
}

