/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.plugin.netty;

import cn.hutool.extra.ssh.JschUtil;
import cn.jiangzeyin.common.JsonMessage;
import com.alibaba.fastjson.JSONObject;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;

public class Progress
implements ChannelProgressiveFutureListener {
    private io.netty.channel.Channel channel;
    private String reqId;
    private Session session;
    private ChannelSftp channelSftp;
    private long totalSize;

    public Progress(io.netty.channel.Channel channel, String reqId, Session session, ChannelSftp channelSftp, long totalSize) {
        this.channel = channel;
        this.reqId = reqId;
        this.session = session;
        this.channelSftp = channelSftp;
        this.totalSize = totalSize;
    }

    public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) throws Exception {
        String progressStr = String.format("%.2f", (double)progress / (double)this.totalSize * 100.0);
        this.send(progressStr);
    }

    public void operationComplete(ChannelProgressiveFuture future) throws Exception {
        this.send("100");
        JschUtil.close((Channel)this.channelSftp);
        JschUtil.close((Session)this.session);
    }

    private void send(String data) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("event", (Object)"progress");
        jsonObject.put("data", (Object)data);
        jsonObject.put("reqId", (Object)this.reqId);
        this.channel.writeAndFlush((Object)new TextWebSocketFrame(JsonMessage.getString((int)200, (String)"", (Object)jsonObject)));
    }
}

