/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.plugin.netty;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.extra.ssh.ChannelType;
import cn.hutool.extra.ssh.JschUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import cn.jiangzeyin.common.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import io.jpom.model.data.SshModel;
import io.jpom.model.data.UserModel;
import io.jpom.plugin.netty.Progress;
import io.jpom.service.node.ssh.SshService;
import io.jpom.service.user.UserService;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class FileServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static ChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private static final TimedCache<String, JSONObject> DOWNLOAD = new TimedCache(TimeUnit.MINUTES.toMillis(1L));
    private static final Map<String, Set<String>> USER_DOWNLOAD = new HashMap<String, Set<String>>();

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest request = (FullHttpRequest)msg;
            if (!request.decoderResult().isSuccess()) {
                FileServerHandler.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            this.handlerReq(ctx, request);
        } else if (msg instanceof WebSocketFrame) {
            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)msg;
            this.handlerSocket(ctx, textWebSocketFrame);
        }
    }

    private void handlerReq(ChannelHandlerContext ctx, FullHttpRequest request) throws IOException {
        Map<String, String> parse = this.parse(request);
        String reqId = parse.get("reqId");
        if (StrUtil.isEmpty((CharSequence)reqId)) {
            FileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        JSONObject jsonObject = (JSONObject)DOWNLOAD.get((Object)reqId);
        if (jsonObject == null) {
            FileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        SshModel sshModel = (SshModel)jsonObject.getObject("ssh", SshModel.class);
        String allPath = jsonObject.getString("allPath");
        ChannelId channelId = (ChannelId)jsonObject.getObject("channelId", ChannelId.class);
        Channel channel = channels.find(channelId);
        if (channel == null) {
            FileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        UserModel user = (UserModel)jsonObject.getObject("user", UserModel.class);
        try {
            Session session = JschUtil.openSession((String)sshModel.getHost(), (int)sshModel.getPort(), (String)sshModel.getUser(), (String)sshModel.getPassword());
            ChannelSftp channelSftp = (ChannelSftp)JschUtil.openChannel((Session)session, (ChannelType)ChannelType.SFTP);
            SftpATTRS attr = channelSftp.stat(allPath);
            long fileSize = attr.getSize();
            PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            ThreadUtil.execute(() -> {
                try {
                    channelSftp.get(allPath, (OutputStream)pipedOutputStream);
                }
                catch (SftpException e) {
                    DefaultSystemLog.getLog().error("\u4e0b\u8f7d\u5f02\u5e38", (Throwable)e);
                }
                IoUtil.close((Closeable)pipedOutputStream);
            });
            Set stringSet = USER_DOWNLOAD.computeIfAbsent(user.getId(), s -> new HashSet());
            stringSet.add(allPath);
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            HttpUtil.setContentLength((HttpMessage)response, (long)fileSize);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/octet-stream");
            String fileName = URLUtil.encode((String)FileUtil.getName((String)allPath));
            response.headers().add("Content-disposition", (Object)("attachment; filename=" + fileName));
            ctx.write((Object)response);
            ChannelFuture sendFileFuture = ctx.write((Object)new HttpChunkedInput((ChunkedInput)new ChunkedStream((InputStream)pipedInputStream)), (ChannelPromise)ctx.newProgressivePromise());
            Progress progress = new Progress(channel, reqId, session, channelSftp, fileSize);
            sendFileFuture.addListener((GenericFutureListener)progress);
            ChannelFuture lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            if (!HttpUtil.isKeepAlive((HttpMessage)request)) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Exception e) {
            DefaultSystemLog.getLog().error("\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            FileServerHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void handlerSocket(ChannelHandlerContext ctx, TextWebSocketFrame textWebSocketFrame) throws IOException {
        String content = textWebSocketFrame.text();
        Channel channel = ctx.channel();
        if (StrUtil.isEmpty((CharSequence)content)) {
            channel.close();
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)content);
        String event = jsonObject.getString("event");
        if ("download".equals(event)) {
            String userId;
            UserService userService = (UserService)SpringUtil.getBean(UserService.class);
            UserModel userModel = userService.checkUser(userId = jsonObject.getString("userId"));
            if (userModel == null) {
                this.sendSocketMsg(ctx, new JsonMessage(800, "\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25"));
                return;
            }
            String id = jsonObject.getString("id");
            SshService sshService = (SshService)SpringUtil.getBean(SshService.class);
            SshModel sshModel = (SshModel)sshService.getItem(id);
            if (sshModel == null) {
                this.sendSocketMsg(ctx, new JsonMessage(405, "\u6ca1\u6709\u5bf9\u5e94\u7684ssh\u4fe1\u606f"));
                return;
            }
            String path = jsonObject.getString("path");
            List fileDirs = sshModel.getFileDirs();
            if (StrUtil.isEmpty((CharSequence)path) || !fileDirs.contains(path)) {
                this.sendSocketMsg(ctx, new JsonMessage(405, "\u975e\u6cd5\u8def\u5f84"));
                return;
            }
            String name = jsonObject.getString("name");
            if (StrUtil.isEmpty((CharSequence)name)) {
                this.sendSocketMsg(ctx, new JsonMessage(405, "\u6ca1\u6709name\u53c2\u6570"));
                return;
            }
            try {
                FileUtil.file((String)path, (String)URLUtil.encode((String)name));
            }
            catch (Exception e) {
                DefaultSystemLog.getLog().error("\u975e\u6cd5\u8def\u5f84", (Throwable)e);
                this.sendSocketMsg(ctx, new JsonMessage(405, "\u975e\u6cd5\u8bf7\u6c42\u4e0b\u8f7d"));
                return;
            }
            String allPath = FileUtil.normalize((String)(path + "/" + name));
            Set<String> strings = USER_DOWNLOAD.get(userModel.getId());
            if (strings != null && strings.contains(allPath)) {
                this.sendSocketMsg(ctx, new JsonMessage(405, "\u6b64\u6587\u4ef6\u6b63\u5728\u4e0b\u8f7d\u4e2d"));
                return;
            }
            String reqId = IdUtil.fastSimpleUUID();
            JSONObject data = new JSONObject();
            data.put("ssh", (Object)sshModel);
            data.put("user", (Object)userModel);
            data.put("channelId", (Object)channel.id());
            data.put("allPath", (Object)allPath);
            DOWNLOAD.put((Object)reqId, (Object)data);
            channels.add((Object)channel);
            JSONObject result = new JSONObject();
            result.put("reqId", (Object)reqId);
            String name1 = FileUtil.getName((String)name);
            result.put("name", (Object)name1);
            result.put("event", (Object)"download");
            this.sendSocketMsg(ctx, new JsonMessage(200, "", (Object)result));
        }
    }

    private void sendSocketMsg(ChannelHandlerContext channelHandlerContext, JsonMessage jsonMessage) {
        channelHandlerContext.channel().writeAndFlush((Object)new TextWebSocketFrame(jsonMessage.toString()));
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        channels.remove((Object)ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            FileServerHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        ctx.channel().close();
        channels.remove((Object)ctx.channel());
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private Map<String, String> parse(FullHttpRequest request) throws IOException {
        HttpMethod method = request.method();
        HashMap<String, String> parmMap = new HashMap<String, String>();
        if (HttpMethod.GET == method) {
            QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
            decoder.parameters().forEach((key, value) -> parmMap.put((String)key, (String)value.get(0)));
        } else if (HttpMethod.POST == method) {
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpRequest)request);
            decoder.offer((HttpContent)request);
            List parmList = decoder.getBodyHttpDatas();
            for (InterfaceHttpData parm : parmList) {
                Attribute data = (Attribute)parm;
                parmMap.put(data.getName(), data.getValue());
            }
        }
        return parmMap;
    }
}

