/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.plugin.netty;

import cn.hutool.core.thread.ThreadUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import io.jpom.plugin.FeatureCallback;
import io.jpom.plugin.PluginFactory;
import io.jpom.plugin.netty.NettyFeatureCallback;
import io.jpom.plugin.netty.NettyThread;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;

@Configuration
public class NettyServerConfig
implements ApplicationListener {
    @Value(value="${netty.port:8888}")
    private int port;
    private NettyThread nettyThread;
    @Resource
    private NettyFeatureCallback nettyFeatureCallback;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            if (this.port <= 0) {
                DefaultSystemLog.getLog().info("\u7aef\u53e3\u914d\u7f6e\u9519\u8bef\uff1a" + this.port);
                return;
            }
            this.nettyThread = new NettyThread(this.port);
            ThreadUtil.execute((Runnable)this.nettyThread);
            PluginFactory.addFeatureCallback((FeatureCallback)this.nettyFeatureCallback);
            return;
        }
        if (event instanceof ContextClosedEvent && this.nettyThread != null) {
            DefaultSystemLog.getLog().info("\u5173\u95ednetty");
            try {
                this.nettyThread.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

