/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.plugin.netty;

import cn.jiangzeyin.common.DefaultSystemLog;
import io.jpom.plugin.netty.FileServerHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;

public class NettyThread
implements Runnable,
AutoCloseable {
    private int port;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;

    public NettyThread(int port) {
        this.port = port;
    }

    @Override
    public void run() {
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast("logging", (ChannelHandler)new LoggingHandler("DEBUG"));
                    pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                    pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(30, 30, 60)});
                    pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/")});
                    pipeline.addLast(new ChannelHandler[]{new FileServerHandler()});
                }
            });
            this.channel = b.bind(this.port).sync().channel();
            this.channel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            DefaultSystemLog.getLog().error("netty \u9519\u8bef", (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        this.channel.close();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }
}

