/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.mojo;

import io.jpom.entity.NodeProjectInfo;
import io.jpom.entity.ProjectInfo;
import io.jpom.util.HttpUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="jpom-project", defaultPhase=LifecyclePhase.PACKAGE)
public class ProjectMojo
extends AbstractMojo {
    @Parameter(required=true)
    private String url;
    @Parameter(required=true)
    private String token;
    @Parameter(required=true)
    private List<String> nodeIds;
    @Parameter
    private ProjectInfo project = new ProjectInfo();
    @Parameter
    private List<NodeProjectInfo> nodeProjects = new ArrayList<NodeProjectInfo>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.nodeIds != null) {
            for (String nodeId : this.nodeIds) {
                NodeProjectInfo projectInfo = this.findItem(nodeId);
                if (projectInfo == null) {
                    projectInfo = new NodeProjectInfo(this.project);
                    projectInfo.setNodeId(nodeId);
                } else {
                    projectInfo.copy(this.project);
                }
                this.send(projectInfo);
            }
        }
        if (this.nodeProjects != null) {
            for (NodeProjectInfo nodeProject : this.nodeProjects) {
                this.send(nodeProject);
            }
        }
        this.getLog().info((CharSequence)"\u5904\u7406\u7ed3\u675f");
    }

    private NodeProjectInfo findItem(String nodeId) {
        Iterator<NodeProjectInfo> iterator = this.nodeProjects.iterator();
        while (iterator.hasNext()) {
            NodeProjectInfo nodeProjectInfo = iterator.next();
            if (!nodeId.equals(nodeProjectInfo.getNodeId())) continue;
            iterator.remove();
            return nodeProjectInfo;
        }
        return null;
    }

    private boolean checkInfo(NodeProjectInfo nodeProjectInfo) {
        String name = nodeProjectInfo.getName();
        if (name == null || "".equals(name)) {
            this.getLog().error((CharSequence)"\u8bf7\u914d\u7f6e project.name");
            return false;
        }
        String id = nodeProjectInfo.getId();
        if (id == null || "".equals(id)) {
            this.getLog().error((CharSequence)"\u8bf7\u914d\u7f6e project.id");
            return false;
        }
        String runMode = nodeProjectInfo.getRunMode();
        if (runMode == null || "".equals(runMode)) {
            this.getLog().error((CharSequence)"\u8bf7\u914d\u7f6e project.runMode");
            return false;
        }
        String whitelistDirectory = nodeProjectInfo.getWhitelistDirectory();
        if (whitelistDirectory == null || "".equals(whitelistDirectory)) {
            this.getLog().error((CharSequence)"\u8bf7\u914d\u7f6e project.whitelistDirectory");
            return false;
        }
        String path = nodeProjectInfo.getPath();
        if (path == null || "".equals(path)) {
            this.getLog().error((CharSequence)"\u8bf7\u914d\u7f6e project.path");
            return false;
        }
        return true;
    }

    private void send(NodeProjectInfo nodeProjectInfo) {
        if (!this.checkInfo(nodeProjectInfo)) {
            return;
        }
        HashMap<String, String> parameter = new HashMap<String, String>(20);
        parameter.put("name", nodeProjectInfo.getName());
        parameter.put("group", nodeProjectInfo.getGroup());
        parameter.put("id", nodeProjectInfo.getId());
        parameter.put("runMode", nodeProjectInfo.getRunMode());
        parameter.put("whitelistDirectory", nodeProjectInfo.getWhitelistDirectory());
        parameter.put("lib", nodeProjectInfo.getPath());
        parameter.put("mainClass", nodeProjectInfo.getMainClass());
        parameter.put("jvm", nodeProjectInfo.getJvm());
        parameter.put("args", nodeProjectInfo.getArgs());
        parameter.put("token", nodeProjectInfo.getWebHook());
        List<NodeProjectInfo.JavaCopy> javaCopys = nodeProjectInfo.getJavaCopys();
        if (javaCopys != null) {
            StringBuilder ids = new StringBuilder();
            for (NodeProjectInfo.JavaCopy javaCopy : javaCopys) {
                String copyId = javaCopy.getId();
                if (copyId == null || copyId.length() <= 0) continue;
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append(copyId);
                parameter.put("jvm_" + copyId, javaCopy.getJvm());
                parameter.put("args_" + copyId, javaCopy.getArgs());
            }
            parameter.put("javaCopyIds", ids.toString());
        }
        HashMap<String, String> header = new HashMap<String, String>(5);
        parameter.put("nodeId", nodeProjectInfo.getNodeId());
        String allUrl = String.format("%s/node/manage/saveProject", this.url);
        header.put("JPOM-USER-TOKEN", this.token);
        this.getLog().info((CharSequence)("\u5904\u7406\uff1a" + nodeProjectInfo.getNodeId()));
        String post = HttpUtils.post(allUrl, parameter, header, (int)TimeUnit.MINUTES.toMillis(1L), (int)TimeUnit.MINUTES.toMillis(1L), "utf-8");
        this.getLog().info((CharSequence)post);
    }
}

