package io.jpom.entity;

import java.util.List;

/**
 * @author bwcx_jzy
 * @date 2019/11/19
 */
public class NodeProjectInfo extends ProjectInfo {

    private String nodeId;

    /**
     * 副本集
     */
    private List<JavaCopy> javaCopys;

    public List<JavaCopy> getJavaCopys() {
        return javaCopys;
    }

    public void setJavaCopys(List<JavaCopy> javaCopys) {
        this.javaCopys = javaCopys;
    }

    public String getNodeId() {
        return nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public NodeProjectInfo(ProjectInfo projectInfo) {
        this.copy(projectInfo);
    }

    public void copy(ProjectInfo projectInfo) {
        if (super.getId() == null) {
            super.setId(projectInfo.getId());
        }
        if (super.getName() == null) {
            super.setName(projectInfo.getName());
        }
        if (getGroup() == null) {
            super.setGroup(projectInfo.getGroup());
        }
        if (getArgs() == null) {
            super.setArgs(projectInfo.getArgs());
        }
        if (getWhitelistDirectory() == null) {
            super.setWhitelistDirectory(projectInfo.getWhitelistDirectory());
        }
        if (getPath() == null) {
            super.setPath(projectInfo.getPath());
        }
        if (getJvm() == null) {
            super.setJvm(projectInfo.getJvm());
        }
        if (getMainClass() == null) {
            super.setMainClass(projectInfo.getMainClass());
        }
        if (getRunMode() == null) {
            super.setRunMode(projectInfo.getRunMode());
        }
        if (getWebHook() == null) {
            super.setWebHook(projectInfo.getWebHook());
        }
    }

    public NodeProjectInfo() {
    }

    public static class JavaCopy {
        private String id;

        private String jvm;

        private String args;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getJvm() {
            return jvm;
        }

        public void setJvm(String jvm) {
            this.jvm = jvm;
        }

        public String getArgs() {
            return args;
        }

        public void setArgs(String args) {
            this.args = args;
        }
    }
}
