/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.util;

import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import io.jpom.util.KeyLock;
import java.io.IOException;
import javax.websocket.Session;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class SocketSessionUtil {
    private static final KeyLock<String> LOCK = new KeyLock();
    private static final int ERROR_TRY_COUNT = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(Session session, String msg) throws IOException {
        if (StrUtil.isEmpty((CharSequence)msg)) {
            return;
        }
        if (!session.isOpen()) {
            throw new RuntimeException("session close ");
        }
        try {
            LOCK.lock(session.getId());
            IOException exception = null;
            int tryCount = 0;
            while (true) {
                ++tryCount;
                if (exception != null) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    session.getBasicRemote().sendText(msg);
                    exception = null;
                }
                catch (IOException e) {
                    DefaultSystemLog.ERROR().error("\u53d1\u9001\u6d88\u606f\u5931\u8d25:" + tryCount, (Throwable)e);
                    exception = e;
                    if (tryCount <= 10) continue;
                }
                break;
            }
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            LOCK.unlock(session.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(WebSocketSession session, String msg) throws IOException {
        if (StrUtil.isEmpty((CharSequence)msg)) {
            return;
        }
        if (!session.isOpen()) {
            throw new RuntimeException("session close ");
        }
        try {
            LOCK.lock(session.getId());
            IOException exception = null;
            int tryCount = 0;
            while (true) {
                ++tryCount;
                if (exception != null) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)msg));
                    exception = null;
                }
                catch (IOException e) {
                    DefaultSystemLog.ERROR().error("\u53d1\u9001\u6d88\u606f\u5931\u8d25:" + tryCount, (Throwable)e);
                    exception = e;
                    if (tryCount <= 10) continue;
                }
                break;
            }
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            LOCK.unlock(session.getId());
        }
    }
}

