/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class KeyLock<K> {
    private final ConcurrentMap<K, LockInfo> map = new ConcurrentHashMap<K, LockInfo>();

    public int getLockKeyCount() {
        return this.map.size();
    }

    public int getLockCount(K k) {
        LockInfo lockInfo = (LockInfo)this.map.get(k);
        return lockInfo == null ? 0 : lockInfo.getLockCount();
    }

    public void unlock(K key) {
        if (key == null) {
            return;
        }
        LockInfo lockInfo = (LockInfo)this.map.get(key);
        if (lockInfo == null) {
            return;
        }
        lockInfo.release();
        if (lockInfo.getLockCount() <= 0) {
            this.map.remove(key);
        }
    }

    public void lock(K key) {
        if (key == null) {
            return;
        }
        LockInfo lockInfo = this.map.computeIfAbsent(key, k -> new LockInfo());
        lockInfo.lock();
    }

    public void lock(K[] keys) {
        if (keys == null) {
            return;
        }
        for (K key : keys) {
            this.lock(key);
        }
    }

    public void unlock(K[] keys) {
        if (keys == null) {
            return;
        }
        for (K key : keys) {
            this.unlock(key);
        }
    }

    private static class LockInfo {
        private final Semaphore semaphore;
        private AtomicInteger lockCount = new AtomicInteger(0);

        private LockInfo() {
            this.semaphore = new Semaphore(1);
        }

        private void lock() {
            this.lockCount.getAndIncrement();
            this.semaphore.acquireUninterruptibly();
        }

        private void release() {
            this.semaphore.release();
            this.lockCount.getAndDecrement();
        }

        private int getLockCount() {
            return this.lockCount.get();
        }
    }
}

