/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.util;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import com.sun.management.OperatingSystemMXBean;
import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import io.jpom.system.JpomRuntimeException;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;

public class JvmUtil {
    private static Method importFrom = null;
    private static final String OLD_JPOM_PID_TAG = "Dapplication";
    private static final String OLD2_JPOM_PID_TAG = "Jpom.application";
    private static final String POM_PID_TAG = "DJpom.application";
    public static final TimedCache<String, Boolean> PID_ERROR;

    public static String getJpomPidTag(String id, String path) {
        return String.format("-%s=%s -DJpom.basedir=%s", POM_PID_TAG, id, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemoryMXBean getMemoryMXBean(String jpomTag) throws Exception {
        VirtualMachine virtualMachine = JvmUtil.getVirtualMachine(jpomTag);
        if (virtualMachine == null) {
            return null;
        }
        try {
            JMXServiceURL url = JvmUtil.getJMXServiceURL(virtualMachine);
            if (url == null) {
                MemoryMXBean memoryMXBean = null;
                return memoryMXBean;
            }
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, null);
            MBeanServerConnection mBeanServerConnection = jmxConnector.getMBeanServerConnection();
            MemoryMXBean memoryMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=Memory", MemoryMXBean.class);
            return memoryMXBean;
        }
        finally {
            virtualMachine.detach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperatingSystemMXBean getOperatingSystemMXBean(String pId) throws Exception {
        VirtualMachine virtualMachine = JvmUtil.getVirtualMachine(Integer.parseInt(pId));
        try {
            JMXServiceURL url = JvmUtil.getJMXServiceURL(virtualMachine);
            if (url == null) {
                OperatingSystemMXBean operatingSystemMXBean = null;
                return operatingSystemMXBean;
            }
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, null);
            MBeanServerConnection mBeanServerConnection = jmxConnector.getMBeanServerConnection();
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
            return operatingSystemMXBean;
        }
        finally {
            virtualMachine.detach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadMXBean getThreadMXBean(String jpomTag) throws Exception {
        VirtualMachine virtualMachine = JvmUtil.getVirtualMachine(jpomTag);
        if (virtualMachine == null) {
            return null;
        }
        try {
            JMXServiceURL url = JvmUtil.getJMXServiceURL(virtualMachine);
            if (url == null) {
                ThreadMXBean threadMXBean = null;
                return threadMXBean;
            }
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, null);
            MBeanServerConnection mBeanServerConnection = jmxConnector.getMBeanServerConnection();
            ThreadMXBean threadMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=Threading", ThreadMXBean.class);
            return threadMXBean;
        }
        finally {
            virtualMachine.detach();
        }
    }

    private static JMXServiceURL getJMXServiceURL(VirtualMachine virtualMachine) throws IOException, AgentLoadException, AgentInitializationException, ClassNotFoundException {
        String address = virtualMachine.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress");
        if (address != null) {
            return new JMXServiceURL(address);
        }
        int pid = Convert.toInt((Object)virtualMachine.id());
        address = JvmUtil.importFrom(pid);
        if (address != null) {
            return new JMXServiceURL(address);
        }
        String agent = JvmUtil.getManagementAgent();
        virtualMachine.loadAgent(agent);
        address = virtualMachine.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress");
        if (address != null) {
            return new JMXServiceURL(address);
        }
        return null;
    }

    public static String importFrom(int pid) {
        if (importFrom == null) {
            throw new JpomRuntimeException("jdk \u73af\u5883\u4e0d\u6b63\u5e38\uff0c\u6ca1\u6709\u627e\u5230\uff1aConnectorAddressLink");
        }
        return (String)ReflectUtil.invoke(null, (Method)importFrom, (Object[])new Object[]{pid});
    }

    public static int getJavaVirtualCount() {
        try {
            List<VirtualMachineDescriptor> descriptorList = VirtualMachine.list();
            return descriptorList.size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static VirtualMachine getVirtualMachine(int pid) {
        String pId = String.valueOf(pid);
        if (PID_ERROR.containsKey((Object)pId)) {
            return null;
        }
        VirtualMachine virtualMachine = null;
        try {
            virtualMachine = VirtualMachine.attach(pId);
        }
        catch (AttachNotSupportedException | IOException e) {
            DefaultSystemLog.ERROR().error("\u83b7\u53d6jvm\u4fe1\u606f\u5931\u8d25\uff1a" + pid, (Throwable)e);
            PID_ERROR.put((Object)pId, (Object)true);
        }
        return virtualMachine;
    }

    public static VirtualMachine getVirtualMachine(String tag) {
        List<VirtualMachineDescriptor> descriptorList = VirtualMachine.list();
        for (VirtualMachineDescriptor virtualMachineDescriptor : descriptorList) {
            VirtualMachine virtualMachine;
            String pid = virtualMachineDescriptor.id();
            if (PID_ERROR.containsKey((Object)pid)) continue;
            try {
                virtualMachine = VirtualMachine.attach(virtualMachineDescriptor);
            }
            catch (AttachNotSupportedException | IOException e) {
                DefaultSystemLog.ERROR().error("\u83b7\u53d6jvm\u4fe1\u606f\u5931\u8d25\uff1a" + pid, (Throwable)e);
                PID_ERROR.put((Object)pid, (Object)true);
                continue;
            }
            if (!JvmUtil.checkVirtualMachineIsJpom(virtualMachine, tag)) continue;
            return virtualMachine;
        }
        return null;
    }

    public static boolean checkVirtualMachineIsJpom(VirtualMachine virtualMachine, String tag) {
        Properties properties;
        String appTag = String.format("-%s=%s ", POM_PID_TAG, tag);
        String appTag2 = String.format("-%s=%s ", OLD_JPOM_PID_TAG, tag);
        String appTag3 = String.format("-%s=%s", OLD2_JPOM_PID_TAG, tag);
        try {
            properties = virtualMachine.getAgentProperties();
        }
        catch (IOException io) {
            return false;
        }
        String args = properties.getProperty("sun.jvm.args", "");
        if (StrUtil.containsAnyIgnoreCase((CharSequence)args, (CharSequence[])new CharSequence[]{appTag, appTag2, appTag3})) {
            return true;
        }
        args = properties.getProperty("sun.java.command", "");
        return StrUtil.containsAnyIgnoreCase((CharSequence)args, (CharSequence[])new CharSequence[]{appTag, appTag2, appTag3});
    }

    private static String getManagementAgent() {
        File file = FileUtil.file((String[])new String[]{SystemUtil.getJavaRuntimeInfo().getHomeDir(), "lib", "management-agent.jar"});
        if (file.exists() && file.isFile()) {
            return file.getAbsolutePath();
        }
        throw new JpomRuntimeException("JDK\u4e2d" + file.getAbsolutePath() + " \u6587\u4ef6\u4e0d\u5b58\u5728");
    }

    public static File getToolsJar() {
        File file = new File(SystemUtil.getJavaRuntimeInfo().getHomeDir());
        return new File(file.getParentFile(), "lib/tools.jar");
    }

    public static List<MonitoredVm> listMainClass(String mainClass) throws MonitorException, URISyntaxException {
        ArrayList<MonitoredVm> monitoredVms = new ArrayList<MonitoredVm>();
        MonitoredHost local = MonitoredHost.getMonitoredHost("localhost");
        HashSet<Integer> vmList = new HashSet<Integer>(local.activeVms());
        for (Object e : vmList) {
            MonitoredVm vm = local.getMonitoredVm(new VmIdentifier("//" + e));
            String processName = MonitoredVmUtil.mainClass(vm, true);
            if (!mainClass.equals(processName)) continue;
            monitoredVms.add(vm);
        }
        return monitoredVms;
    }

    static {
        int v = StrUtil.compareVersion((CharSequence)SystemUtil.getJavaInfo().getVersion(), (CharSequence)"11.0");
        Class<?> cls = null;
        try {
            cls = v >= 0 ? Class.forName("jdk.internal.agent.ConnectorAddressLink") : Class.forName("sun.management.ConnectorAddressLink");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (cls != null) {
            importFrom = ReflectUtil.getMethod(cls, (String)"importFrom", (Class[])new Class[]{Integer.class});
        }
        PID_ERROR = new TimedCache(TimeUnit.DAYS.toMillis(1L));
    }
}

