/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class JsonFileUtil {
    private static final ReentrantReadWriteLock FILE_LOCK = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock READ_LOCK = FILE_LOCK.readLock();
    private static final ReentrantReadWriteLock.WriteLock WRITE_LOCK = FILE_LOCK.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSON readJson(String path) throws FileNotFoundException {
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u914d\u7f6e\u6587\u4ef6\uff1a" + path);
        }
        READ_LOCK.lock();
        try {
            String json = FileUtil.readString((File)file, (String)"UTF-8");
            if (StrUtil.isEmpty((CharSequence)json)) {
                JSONObject jSONObject = new JSONObject();
                return jSONObject;
            }
            JSON jSON = (JSON)JSON.parse((String)json);
            return jSON;
        }
        finally {
            READ_LOCK.unlock();
        }
    }

    public static void saveJson(String path, JSON json) {
        WRITE_LOCK.lock();
        try {
            String newsJson = JSON.toJSONString((Object)json, (boolean)true);
            FileUtil.writeString((String)newsJson, (String)path, (String)"UTF-8");
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    public static <T> JSONObject arrayToObjById(JSONArray array) {
        JSONObject jsonObject = new JSONObject();
        array.forEach(o -> {
            JSONObject jsonObject1 = (JSONObject)o;
            jsonObject.put(jsonObject1.getString("id"), (Object)jsonObject1);
        });
        return jsonObject;
    }
}

