/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.util;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.LineHandler;
import cn.hutool.core.io.file.FileMode;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import io.jpom.system.ExtConfigBean;
import io.jpom.util.CharsetDetector;
import io.jpom.util.LimitQueue;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class FileTailWatcherRun
implements Runnable {
    private final LimitQueue<String> limitQueue = new LimitQueue(ExtConfigBean.getInstance().getLogInitReadLine());
    private final RandomAccessFile randomFile;
    private boolean start = false;
    private final Charset charset;
    private LineHandler lineHandler;

    public LimitQueue<String> getLimitQueue() {
        return this.limitQueue;
    }

    FileTailWatcherRun(File file, LineHandler lineHandler) throws IOException {
        this.lineHandler = lineHandler;
        this.randomFile = new RandomAccessFile(file, FileMode.r.name());
        Charset detSet = ExtConfigBean.getInstance().getLogFileCharset();
        if (detSet == null) {
            detSet = CharsetUtil.charset((String)new CharsetDetector().detectChineseCharset(file));
            detSet = detSet == StandardCharsets.US_ASCII ? CharsetUtil.CHARSET_UTF_8 : detSet;
        }
        this.charset = detSet;
        if (file.length() > 0L) {
            this.startRead();
        }
    }

    private void startRead() throws IOException {
        if (ExtConfigBean.getInstance().getLogInitReadLine() == 0) {
            return;
        }
        long len = this.randomFile.length();
        long start = this.randomFile.getFilePointer();
        long nextEnd = start + len - 1L;
        this.randomFile.seek(nextEnd);
        while (nextEnd > start && !this.limitQueue.full()) {
            int c = this.randomFile.read();
            if (c == 10 || c == 13) {
                this.readLine();
                --nextEnd;
            }
            this.randomFile.seek(--nextEnd);
            if (nextEnd != 0L) continue;
            this.readLine();
            break;
        }
        this.randomFile.seek(len);
    }

    private void readLine() throws IOException {
        String line = this.randomFile.readLine();
        if (line != null) {
            line = CharsetUtil.convert((String)line, (Charset)CharsetUtil.CHARSET_ISO_8859_1, (Charset)this.charset);
            this.limitQueue.offerFirst(line);
        }
    }

    private void read() throws IOException {
        String tmp;
        long currentLength = this.randomFile.length();
        long position = this.randomFile.getFilePointer();
        if (0L == currentLength || currentLength == position) {
            return;
        }
        if (currentLength < position) {
            this.randomFile.seek(currentLength);
            return;
        }
        while ((tmp = this.randomFile.readLine()) != null) {
            tmp = CharsetUtil.convert((String)tmp, (Charset)CharsetUtil.CHARSET_ISO_8859_1, (Charset)this.charset);
            this.limitQueue.offer(tmp);
            this.lineHandler.handle(tmp);
        }
        this.randomFile.seek(currentLength);
    }

    public void start() {
        if (this.start) {
            return;
        }
        this.start = true;
        ThreadUtil.execute((Runnable)this);
    }

    @Override
    public void run() {
        while (this.start) {
            try {
                this.read();
            }
            catch (IOException e) {
                DefaultSystemLog.ERROR().error("\u8bfb\u53d6\u6587\u4ef6\u53d1\u9001\u5f02\u5e38", (Throwable)e);
                this.lineHandler.handle("\u8bfb\u53d6\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.close();
    }

    public void close() {
        this.start = false;
        IoUtil.close((Closeable)this.randomFile);
    }
}

