/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CommandUtil {
    private static final List<String> COMMAND = new ArrayList<String>();
    public static final String SUFFIX;

    public static List<String> getCommand() {
        return (List)ObjectUtil.clone(COMMAND);
    }

    public static String execSystemCommand(String command) {
        return CommandUtil.execSystemCommand(command, null);
    }

    public static String execSystemCommand(String command, File file) {
        String newCommand = StrUtil.replace((CharSequence)command, (CharSequence)"\r\n", (CharSequence)" ");
        newCommand = StrUtil.replace((CharSequence)newCommand, (CharSequence)"\n", (CharSequence)" ");
        String result = "error";
        try {
            List<String> commands = CommandUtil.getCommand();
            commands.add(newCommand);
            String[] cmd = commands.toArray(new String[0]);
            result = CommandUtil.exec(cmd, file);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u6267\u884c\u547d\u4ee4\u5f02\u5e38", (Throwable)e);
            result = result + e.getMessage();
        }
        return result;
    }

    private static String exec(String[] cmd, File file) throws IOException {
        DefaultSystemLog.LOG().info(Arrays.toString(cmd));
        Process process = new ProcessBuilder(cmd).directory(file).redirectErrorStream(true).start();
        return RuntimeUtil.getResult((Process)process);
    }

    public static void asyncExeLocalCommand(File file, String command) throws Exception {
        if (SystemUtil.getOsInfo().isWindows()) {
            CommandUtil.execSystemCommand(command, file);
            return;
        }
        List<String> commands = CommandUtil.getCommand();
        commands.add(command);
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb.directory(file);
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
        pb.start();
    }

    static {
        if (SystemUtil.getOsInfo().isLinux()) {
            COMMAND.add("/bin/sh");
            COMMAND.add("-c");
        } else if (SystemUtil.getOsInfo().isMac()) {
            COMMAND.add("/bin/sh");
            COMMAND.add("-c");
        } else {
            COMMAND.add("cmd");
            COMMAND.add("/c");
        }
        SUFFIX = SystemUtil.getOsInfo().isWindows() ? "bat" : "sh";
    }
}

