/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class CharsetDetector
implements nsICharsetDetectionObserver {
    private boolean found = false;
    private String result;

    public String detectChineseCharset(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        String[] val = this.detectChineseCharset(new FileInputStream(file));
        if (val == null || val.length <= 0) {
            return null;
        }
        return val[0];
    }

    private String[] detectChineseCharset(InputStream in) throws IOException {
        String[] prob;
        int len;
        nsDetector det = new nsDetector(2);
        det.Init((nsICharsetDetectionObserver)this);
        BufferedInputStream imp = new BufferedInputStream(in);
        byte[] buf = new byte[1024];
        boolean isAscii = true;
        while ((len = imp.read(buf, 0, buf.length)) != -1) {
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (isAscii || !det.DoIt(buf, len, false)) continue;
        }
        imp.close();
        in.close();
        det.DataEnd();
        if (isAscii) {
            this.found = true;
            prob = new String[]{"ASCII"};
        } else {
            prob = this.found ? new String[]{this.result} : det.getProbableCharsets();
        }
        return prob;
    }

    public void Notify(String charset) {
        this.found = true;
        this.result = charset;
    }
}

