/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.util;

import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import io.jpom.system.JpomRuntimeException;
import io.jpom.util.FileTailWatcherRun;
import io.jpom.util.LimitQueue;
import io.jpom.util.SocketSessionUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.websocket.Session;
import org.springframework.web.socket.WebSocketSession;

public abstract class BaseFileTailWatcher<T> {
    protected FileTailWatcherRun tailWatcherRun;
    protected File logFile;
    protected final Set<T> socketSessions = new HashSet<T>();

    public BaseFileTailWatcher(File logFile) throws IOException {
        this.logFile = logFile;
        this.tailWatcherRun = new FileTailWatcherRun(logFile, this::sendAll);
    }

    protected void send(T session, String msg) {
        block4: {
            try {
                if (session instanceof Session) {
                    SocketSessionUtil.send((Session)session, msg);
                    break block4;
                }
                if (session instanceof WebSocketSession) {
                    SocketSessionUtil.send((WebSocketSession)session, msg);
                    break block4;
                }
                throw new JpomRuntimeException("\u6ca1\u6709\u5bf9\u5e94\u7c7b\u578b");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void sendAll(String msg) {
        Iterator<T> iterator = this.socketSessions.iterator();
        while (iterator.hasNext()) {
            T socketSession = iterator.next();
            try {
                this.send(socketSession, msg);
            }
            catch (Exception e) {
                DefaultSystemLog.ERROR().error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
                iterator.remove();
            }
        }
        if (this.socketSessions.isEmpty()) {
            this.close();
        }
    }

    protected void add(T session, String name) {
        if (this.socketSessions.contains(session) || this.socketSessions.add(session)) {
            LimitQueue<String> limitQueue = this.tailWatcherRun.getLimitQueue();
            if (limitQueue.size() <= 0) {
                this.send(session, "\u65e5\u5fd7\u6587\u4ef6\u4e3a\u7a7a");
                return;
            }
            this.send(session, StrUtil.format((CharSequence)"\u76d1\u542c{}\u65e5\u5fd7\u6210\u529f,\u76ee\u524d\u5171\u6709{}\u4eba\u6b63\u5728\u67e5\u770b", (Object[])new Object[]{name, this.socketSessions.size()}));
            for (String s : limitQueue) {
                this.send(session, s);
            }
        }
    }

    protected void close() {
        this.tailWatcherRun.close();
    }
}

