/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.system.init;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ClassUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.PreLoadClass;
import cn.jiangzeyin.common.PreLoadMethod;
import io.jpom.JpomApplication;
import io.jpom.common.JpomManifest;
import io.jpom.system.ConfigBean;
import io.jpom.system.ExtConfigBean;
import io.jpom.util.JvmUtil;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.VmIdentifier;

@PreLoadClass
public class CheckPath {
    private static final String[] CLASS_NAME = new String[]{"sun.jvmstat.monitor.MonitorException", "com.sun.tools.attach.VirtualMachine"};

    @PreLoadMethod(value=2)
    private static void checkToolsJar() {
        try {
            for (String item : CLASS_NAME) {
                ClassUtil.loadClass((String)item, (boolean)false);
            }
        }
        catch (Exception e) {
            File file = JvmUtil.getToolsJar();
            if (file.exists() && file.isFile()) {
                DefaultSystemLog.ERROR().error("Jpom\u672a\u80fd\u6b63\u5e38\u52a0\u8f7dtools.jar,\u8bf7\u68c0\u67e5\u5f53\u524d\u7cfb\u7edf\u73af\u5883\u53d8\u91cf\u662f\u5426\u914d\u7f6e\uff1aJAVA_HOME\uff0c\u6216\u8005\u68c0\u67e5Jpom\u7ba1\u7406\u547d\u4ee4\u662f\u5426\u6b63\u786e", (Throwable)e);
            } else {
                DefaultSystemLog.ERROR().error("\u5f53\u524dJDK\u4e2d\u6ca1\u6709\u627e\u5230tools.jar,\u8bf7\u68c0\u67e5\u5f53\u524dJDK\u662f\u5426\u5b89\u88c5\u5b8c\u6574\uff0c\u6587\u4ef6\u5b8c\u6574\u8def\u5f84\u662f\uff1a" + file.getAbsolutePath(), (Throwable)e);
            }
            System.exit(-1);
        }
    }

    @PreLoadMethod(value=2)
    private static void checkDuplicateRun() {
        Class<?> appClass = JpomApplication.getAppClass();
        try {
            String pid = String.valueOf(JpomManifest.getInstance().getPid());
            List<MonitoredVm> monitoredVms = JvmUtil.listMainClass(appClass.getName());
            monitoredVms.forEach(monitoredVm -> {
                VmIdentifier vmIdentifier = monitoredVm.getVmIdentifier();
                if (pid.equals(vmIdentifier.getUserInfo())) {
                    return;
                }
                DefaultSystemLog.LOG().info("Jpom \u7a0b\u5e8f\u5efa\u8bae\u4e00\u4e2a\u673a\u5668\u4e0a\u53ea\u8fd0\u884c\u4e00\u4e2a\u5bf9\u5e94\u7684\u7a0b\u5e8f\uff1a" + (Object)((Object)JpomApplication.getAppType()));
            });
        }
        catch (URISyntaxException | MonitorException exception) {
            // empty catch block
        }
    }

    @PreLoadMethod(value=3)
    private static void reqXssLog() {
        if (!ExtConfigBean.getInstance().isConsoleLogReqXss()) {
            DefaultSystemLog.setLogCallback((type, log) -> {
                if (type == DefaultSystemLog.LogType.REQUEST_ERROR) {
                    DefaultSystemLog.LOG((DefaultSystemLog.LogType)DefaultSystemLog.LogType.REQUEST).info(Arrays.toString(log));
                }
            });
        }
    }

    @PreLoadMethod(value=4)
    private static void clearTemp() {
        File file = ConfigBean.getInstance().getTempPath();
        FileUtil.clean((File)file);
    }
}

