/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.system;

import ch.qos.logback.core.PropertyDefinerBase;
import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import io.jpom.JpomApplication;
import io.jpom.common.JpomManifest;
import io.jpom.system.AopLogInterface;
import io.jpom.system.ExtConfigBean;
import io.jpom.util.StringUtil;
import java.io.File;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Aspect
@Component
public class WebAopLog
extends PropertyDefinerBase {
    private static final ThreadLocal<Boolean> IS_LOG = new ThreadLocal();
    private static volatile AopLogInterface aopLogInterface;

    public static synchronized void setAopLogInterface(AopLogInterface aopLogInterface) {
        WebAopLog.aopLogInterface = aopLogInterface;
    }

    @Pointcut(value="execution(public * io.jpom.controller..*.*(..))")
    public void webLog() {
    }

    @Before(value="webLog()")
    public void doBefore(JoinPoint joinPoint) {
        RestController restController;
        MethodSignature methodSignature;
        ResponseBody responseBody;
        if (aopLogInterface != null) {
            aopLogInterface.before(joinPoint);
        }
        IS_LOG.set(ExtConfigBean.getInstance().isConsoleLogReqResponse());
        Signature signature = joinPoint.getSignature();
        if (signature instanceof MethodSignature && (responseBody = (methodSignature = (MethodSignature)signature).getMethod().getAnnotation(ResponseBody.class)) == null && (restController = joinPoint.getTarget().getClass().getAnnotation(RestController.class)) == null) {
            IS_LOG.set(false);
        }
    }

    @AfterReturning(returning="ret", pointcut="webLog()")
    public void doAfterReturning(Object ret) {
        if (aopLogInterface != null) {
            aopLogInterface.afterReturning(ret);
        }
        try {
            if (ret == null) {
                return;
            }
            Boolean isLog = IS_LOG.get();
            if (isLog != null && !isLog.booleanValue()) {
                return;
            }
            DefaultSystemLog.LOG().info(" :" + ret.toString());
        }
        finally {
            IS_LOG.remove();
        }
    }

    public String getPropertyValue() {
        String path = StringUtil.getArgsValue(JpomApplication.getArgs(), "jpom.log");
        if (StrUtil.isEmpty((CharSequence)path)) {
            File file = JpomManifest.getRunPath();
            if (file.isFile()) {
                file = file.getParentFile().getParentFile();
            }
            file = new File(file, "log");
            path = file.getPath();
        }
        DefaultSystemLog.configPath((String)path, (boolean)false);
        return path;
    }
}

