/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.system;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.spring.SpringUtil;
import io.jpom.JpomApplication;
import io.jpom.common.JpomManifest;
import io.jpom.system.JpomRuntimeException;
import java.io.File;
import java.nio.charset.Charset;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@Configuration
public class ExtConfigBean {
    static final String FILE_NAME = "extConfig.yml";
    private static Resource resource;
    @Value(value="${consoleLog.reqXss:true}")
    private boolean consoleLogReqXss;
    @Value(value="${consoleLog.reqResponse:true}")
    private boolean consoleLogReqResponse;
    @Value(value="${log.fileCharset:}")
    private String logFileCharset;
    @Value(value="${log.intiReadLine:10}")
    private int logInitReadLine;
    private Charset logFileCharsets;
    private static ExtConfigBean extConfigBean;
    @Value(value="${jpom.path}")
    private String path;

    public int getLogInitReadLine() {
        if (this.logInitReadLine < 0) {
            return 10;
        }
        return this.logInitReadLine;
    }

    public Charset getLogFileCharset() {
        return this.logFileCharsets;
    }

    public boolean isConsoleLogReqResponse() {
        return this.consoleLogReqResponse;
    }

    public boolean isConsoleLogReqXss() {
        return this.consoleLogReqXss;
    }

    public static Resource getResource() {
        if (resource != null) {
            return resource;
        }
        File file = JpomManifest.getRunPath();
        if (file.isFile()) {
            file = file.getParentFile().getParentFile();
            if ((file = new File(file, FILE_NAME)).exists() && file.isFile()) {
                resource = new FileSystemResource(file);
                return resource;
            }
        }
        resource = new ClassPathResource("/bin/extConfig.yml");
        return resource;
    }

    public static File getResourceFile() {
        File file = JpomManifest.getRunPath();
        file = file.getParentFile().getParentFile();
        file = new File(file, FILE_NAME);
        return file;
    }

    public static ExtConfigBean getInstance() {
        if (extConfigBean == null) {
            extConfigBean = (ExtConfigBean)SpringUtil.getBean(ExtConfigBean.class);
            if (StrUtil.isNotBlank((CharSequence)ExtConfigBean.extConfigBean.logFileCharset)) {
                try {
                    ExtConfigBean.extConfigBean.logFileCharsets = CharsetUtil.charset((String)ExtConfigBean.extConfigBean.logFileCharset);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return extConfigBean;
    }

    public String getPath() {
        if (StrUtil.isEmpty((CharSequence)this.path)) {
            if (JpomManifest.getInstance().isDebug()) {
                this.path = ("/jpom/" + JpomApplication.getAppType().name() + "/").toLowerCase();
            } else {
                File file = JpomManifest.getRunPath();
                if (!file.exists() && !file.isFile()) {
                    throw new JpomRuntimeException("\u8bf7\u914d\u7f6e\u8fd0\u884c\u8def\u5f84\u5c5e\u6027\u3010jpom.path\u3011");
                }
                this.path = file.getParentFile().getParentFile().getAbsolutePath();
            }
            DefaultSystemLog.LOG().info("\u5f53\u524d\u6570\u636e\u8def\u5f84\uff1a{}", (Object)this.path);
        }
        return this.path;
    }

    public String getAbsolutePath() {
        return FileUtil.getAbsolutePath((File)FileUtil.file((String)this.getPath()));
    }
}

