/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.system;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import cn.jiangzeyin.common.spring.SpringUtil;
import io.jpom.JpomApplication;
import io.jpom.common.JpomManifest;
import io.jpom.common.Type;
import io.jpom.system.ExtConfigBean;
import java.io.File;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConfigBean {
    public static final String JPOM_SERVER_USER_NAME = "Jpom-Server-UserName";
    public static final String JPOM_AGENT_AUTHORIZE = "Jpom-Agent-Authorize";
    public static final String DATA = "data";
    public static final int AUTHORIZE_ERROR = 900;
    public static final String AUTHORIZE = "agent_authorize.json";
    public static final String AUTHORIZE_USER_KEY = "jpom.authorize.agentName";
    public static final String AUTHORIZE_PWD_KEY = "jpom.authorize.agentPwd";
    public static final String UPGRADE = "upgrade.json";
    @Value(value="${jpom.applicationTag:}")
    public String applicationTag;
    @Value(value="${server.port}")
    private int port;
    private static ConfigBean configBean;

    public static ConfigBean getInstance() {
        if (configBean == null) {
            configBean = (ConfigBean)SpringUtil.getBean(ConfigBean.class);
        }
        return configBean;
    }

    public int getPort() {
        return this.port;
    }

    public String getDataPath() {
        String dataPath = FileUtil.normalize((String)(ExtConfigBean.getInstance().getPath() + "/" + DATA));
        FileUtil.mkdir((String)dataPath);
        return dataPath;
    }

    public File getPidFile() {
        return new File(this.getDataPath(), StrUtil.format((CharSequence)"pid.{}.{}", (Object[])new Object[]{JpomApplication.getAppType().name(), JpomManifest.getInstance().getPid()}));
    }

    public File getApplicationJpomInfo(Type type) {
        return FileUtil.file((String[])new String[]{SystemUtil.getUserInfo().getTempDir(), "jpom", type.name()});
    }

    public String getAgentAutoAuthorizeFile(String dataPath) {
        return FileUtil.normalize((String)(dataPath + "/" + AUTHORIZE));
    }

    public File getTempPath() {
        File file = new File(ConfigBean.getInstance().getDataPath());
        file = new File(file.getPath() + "/temp/");
        FileUtil.mkdir((File)file);
        return file;
    }
}

