/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.plugin;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.JarClassLoader;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import io.jpom.common.JpomManifest;
import io.jpom.plugin.FeatureCallback;
import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class PluginFactory
implements ApplicationContextInitializer {
    private static final List<FeatureCallback> FEATURE_CALLBACKS = new ArrayList<FeatureCallback>();

    public static void addFeatureCallback(FeatureCallback featureCallback) {
        FEATURE_CALLBACKS.add(featureCallback);
    }

    public static List<FeatureCallback> getFeatureCallbacks() {
        return FEATURE_CALLBACKS;
    }

    private static void init() {
        if (JpomManifest.getInstance().isDebug()) {
            return;
        }
        File runPath = JpomManifest.getRunPath().getParentFile();
        File plugin = FileUtil.file((File)runPath, (String)"plugin");
        if (!plugin.exists() || plugin.isFile()) {
            return;
        }
        File[] files = plugin.listFiles(File::isDirectory);
        if (files == null) {
            return;
        }
        for (File file : files) {
            File[] listFiles;
            File lib = FileUtil.file((File)file, (String)"lib");
            if (!lib.exists() || lib.isFile() || (listFiles = lib.listFiles((dir, name) -> StrUtil.endWith((CharSequence)name, (CharSequence)".jar", (boolean)true))) == null || listFiles.length <= 0) continue;
            PluginFactory.addPlugin(file.getName(), lib);
        }
    }

    private static void addPlugin(String pluginName, File file) {
        DefaultSystemLog.LOG().info("\u52a0\u8f7d\uff1a{}\u63d2\u4ef6", (Object)pluginName);
        ClassLoader contextClassLoader = ClassLoaderUtil.getClassLoader();
        JarClassLoader.loadJar((URLClassLoader)((URLClassLoader)contextClassLoader), (File)file);
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        PluginFactory.init();
    }
}

