/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.common.interceptor;

import cn.jiangzeyin.common.interceptor.BaseInterceptor;
import cn.jiangzeyin.common.interceptor.InterceptorPattens;
import io.jpom.plugin.ClassFeature;
import io.jpom.plugin.Feature;
import io.jpom.plugin.FeatureCallback;
import io.jpom.plugin.MethodFeature;
import io.jpom.plugin.PluginFactory;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;

@InterceptorPattens(sort=0x7FFFFFFF)
public class PluginFeatureInterceptor
extends BaseInterceptor {
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
        HandlerMethod handlerMethod = this.getHandlerMethod(handler);
        if (handlerMethod == null) {
            return;
        }
        Feature methodAnnotation = (Feature)handlerMethod.getMethodAnnotation(Feature.class);
        Feature annotation = handlerMethod.getBeanType().getAnnotation(Feature.class);
        if (methodAnnotation != null && annotation != null && methodAnnotation.method() != MethodFeature.NULL && annotation.cls() != ClassFeature.NULL) {
            List<FeatureCallback> featureCallbacks = PluginFactory.getFeatureCallbacks();
            featureCallbacks.forEach(featureCallback -> featureCallback.postHandle(request, annotation.cls(), methodAnnotation.method(), new Object[0]));
        }
    }
}

