/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.common;

import cn.hutool.core.date.BetweenFormater;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.JarClassLoader;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.jpom.JpomApplication;
import io.jpom.common.Type;
import io.jpom.system.ConfigBean;
import io.jpom.system.JpomRuntimeException;
import io.jpom.util.CommandUtil;
import io.jpom.util.JsonFileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.springframework.boot.system.ApplicationHome;

public class JpomManifest {
    private static JpomManifest JPOM_MANIFEST;
    private String version = "dev";
    private String timeStamp;
    private long pid = SystemUtil.getCurrentPID();
    private Type type = JpomApplication.getAppType();
    private int port;
    private String dataPath;

    private static synchronized void init() {
        if (JPOM_MANIFEST != null) {
            return;
        }
        JPOM_MANIFEST = new JpomManifest();
        File jarFile = JpomManifest.getRunPath();
        if (jarFile.isFile()) {
            try (JarFile jarFile1 = new JarFile(jarFile);){
                Manifest manifest = jarFile1.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                String version = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                if (version != null) {
                    JPOM_MANIFEST.setVersion(version);
                    String timeStamp = attributes.getValue("Jpom-Timestamp");
                    JPOM_MANIFEST.setTimeStamp(timeStamp);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private JpomManifest() {
    }

    public static JpomManifest getInstance() {
        JpomManifest.init();
        return JPOM_MANIFEST;
    }

    public Type getType() {
        return this.type;
    }

    public long getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isDebug() {
        return "dev".equals(this.getVersion());
    }

    public void setVersion(String version) {
        if (StrUtil.isNotEmpty((CharSequence)version)) {
            this.version = version;
        }
    }

    public String getTimeStamp() {
        if (this.timeStamp == null) {
            long uptime = SystemUtil.getRuntimeMXBean().getUptime();
            long statTime = System.currentTimeMillis() - uptime;
            return new DateTime(statTime).toString();
        }
        return this.timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = JpomManifest.parseJpomTime(timeStamp);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        if (this.port == 0) {
            this.port = ConfigBean.getInstance().getPort();
        }
        return this.port;
    }

    public String getDataPath() {
        if (StrUtil.isEmpty((CharSequence)this.dataPath)) {
            this.dataPath = ConfigBean.getInstance().getDataPath();
        }
        return this.dataPath;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public String getUpTime() {
        long uptime = SystemUtil.getRuntimeMXBean().getUptime();
        return DateUtil.formatBetween((long)uptime, (BetweenFormater.Level)BetweenFormater.Level.SECOND);
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public static File getRunPath() {
        ApplicationHome home = new ApplicationHome(JpomApplication.getAppClass());
        String path = home.getSource() == null ? "" : home.getSource().getAbsolutePath();
        return FileUtil.file((String)path);
    }

    public static String parseJpomTime(String timeStamp) {
        if (StrUtil.isNotEmpty((CharSequence)timeStamp)) {
            try {
                DateTime dateTime = DateUtil.parseUTC((String)timeStamp);
                return dateTime.toStringDefaultTimeZone();
            }
            catch (Exception e) {
                return timeStamp;
            }
        }
        return "dev";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonMessage checkJpomJar(String path, Class clsName) {
        File jarFile = new File(path);
        try (JarFile jarFile1 = new JarFile(jarFile);){
            Manifest manifest = jarFile1.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String mainClass = attributes.getValue("Main-Class");
            if (mainClass == null) {
                JsonMessage jsonMessage = new JsonMessage(405, "\u6e05\u5355\u6587\u4ef6\u4e2d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684MainClass\u5c5e\u6027");
                return jsonMessage;
            }
            JarClassLoader jarClassLoader = JarClassLoader.load((File)jarFile);
            try {
                jarClassLoader.loadClass(mainClass);
            }
            catch (ClassNotFoundException notFound) {
                JsonMessage jsonMessage = new JsonMessage(405, "\u4e2d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684MainClass:" + mainClass);
                if (jarFile1 == null) return jsonMessage;
                if (var5_5 == null) {
                    jarFile1.close();
                    return jsonMessage;
                }
                try {
                    jarFile1.close();
                    return jsonMessage;
                }
                catch (Throwable throwable) {
                    var5_5.addSuppressed(throwable);
                    return jsonMessage;
                }
            }
            ZipEntry entry = jarFile1.getEntry(StrUtil.format((CharSequence)"BOOT-INF/classes/{}.class", (Object[])new Object[]{StrUtil.replace((CharSequence)clsName.getName(), (CharSequence)".", (CharSequence)"/")}));
            if (entry == null) {
                JsonMessage jsonMessage = new JsonMessage(405, "\u6b64\u5305\u4e0d\u662fJpom\u3010" + JpomApplication.getAppType().name() + "\u3011\u5305");
                return jsonMessage;
            }
            String version = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            if (StrUtil.isEmpty((CharSequence)version)) {
                JsonMessage jsonMessage = new JsonMessage(405, "\u6b64\u5305\u6ca1\u6709\u7248\u672c\u53f7");
                return jsonMessage;
            }
            String timeStamp = attributes.getValue("Jpom-Timestamp");
            if (StrUtil.isEmpty((CharSequence)timeStamp)) {
                JsonMessage jsonMessage = new JsonMessage(405, "\u6b64\u5305\u6ca1\u6709\u7248\u672c\u53f7");
                return jsonMessage;
            }
            timeStamp = JpomManifest.parseJpomTime(timeStamp);
            if (!StrUtil.equals((CharSequence)version, (CharSequence)JpomManifest.getInstance().getVersion())) return new JsonMessage(200, version);
            if (!StrUtil.equals((CharSequence)timeStamp, (CharSequence)JpomManifest.getInstance().getTimeStamp())) return new JsonMessage(200, version);
            JsonMessage jsonMessage = new JsonMessage(405, "\u65b0\u5305\u548c\u6b63\u5728\u8fd0\u884c\u7684\u5305\u4e00\u81f4");
            return jsonMessage;
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u89e3\u6790jar", (Throwable)e);
            return new JsonMessage(500, " \u89e3\u6790\u9519\u8bef:" + e.getMessage());
        }
    }

    public static void releaseJar(String path, String version) {
        String newFile;
        File to;
        File runFile = JpomManifest.getRunPath();
        File runPath = runFile.getParentFile();
        if (!runPath.isDirectory()) {
            throw new JpomRuntimeException(runPath.getAbsolutePath() + " error");
        }
        String upgrade = FileUtil.file((File)runPath, (String)"upgrade.json").getAbsolutePath();
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)JsonFileUtil.readJson(upgrade);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (jsonObject == null) {
            jsonObject = new JSONObject();
        }
        jsonObject.put("beforeJar", (Object)runFile.getName());
        if (StrUtil.equals((CharSequence)version, (CharSequence)JpomManifest.getInstance().getVersion())) {
            version = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{version, System.currentTimeMillis()});
        }
        if ((to = FileUtil.file((File)runPath, (String)(newFile = JpomApplication.getAppType().name() + "-" + version + ".jar"))).exists()) {
            throw new JpomRuntimeException(newFile + " \u5df2\u7ecf\u5b58\u5728\u5566");
        }
        FileUtil.move((File)new File(path), (File)to, (boolean)true);
        jsonObject.put("newJar", (Object)newFile);
        jsonObject.put("updateTime", (Object)new DateTime().toString());
        JsonFileUtil.saveJson(upgrade, (JSON)jsonObject);
        LinkedList newData = new LinkedList();
        FileUtil.readLines((File)JpomManifest.getScriptFile(), (Charset)JpomApplication.getCharset(), line -> {
            if (!line.startsWith(String.valueOf('\t')) && !line.startsWith(String.valueOf(' ')) && StrUtil.containsAny((CharSequence)line, (CharSequence[])new CharSequence[]{"RUNJAR="})) {
                if ("sh".equals(CommandUtil.SUFFIX)) {
                    newData.add(StrUtil.format((CharSequence)"RUNJAR=\"{}\"", (Object[])new Object[]{newFile}));
                } else if ("bat".equals(CommandUtil.SUFFIX)) {
                    newData.add(StrUtil.format((CharSequence)"set RUNJAR={}", (Object[])new Object[]{newFile}));
                } else {
                    newData.add(line);
                }
            } else {
                newData.add(line);
            }
        });
        FileUtil.writeLines(newData, (File)JpomManifest.getScriptFile(), (Charset)JpomApplication.getCharset());
    }

    public static File getScriptFile() {
        String type;
        File runPath = JpomManifest.getRunPath().getParentFile().getParentFile();
        File scriptFile = FileUtil.file((File)runPath, (String)StrUtil.format((CharSequence)"{}.{}", (Object[])new Object[]{type = JpomApplication.getAppType().name(), CommandUtil.SUFFIX}));
        if (!scriptFile.exists() || scriptFile.isDirectory()) {
            throw new JpomRuntimeException("\u5f53\u524d\u670d\u52a1\u4e2d\u6ca1\u6709\u547d\u4ee4\u811a\u672c\uff1a" + StrUtil.format((CharSequence)"{}.{}", (Object[])new Object[]{type, CommandUtil.SUFFIX}));
        }
        return scriptFile;
    }
}

