/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.common;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.spring.SpringUtil;
import cn.jiangzeyin.common.spring.event.ApplicationEventClient;
import cn.jiangzeyin.common.spring.event.ApplicationEventLoad;
import com.alibaba.fastjson.JSONObject;
import io.jpom.JpomApplication;
import io.jpom.common.JpomManifest;
import io.jpom.system.ConfigBean;
import io.jpom.system.ExtConfigBean;
import io.jpom.util.JsonFileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.util.List;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextClosedEvent;

public class JpomApplicationEvent
implements ApplicationEventClient {
    private FileLock lock;
    private FileOutputStream fileOutputStream;
    private FileChannel fileChannel;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            JpomApplicationEvent.checkPath();
            List files = FileUtil.loopFiles((String)ConfigBean.getInstance().getDataPath(), pathname -> pathname.getName().startsWith("pid."));
            files.forEach(FileUtil::del);
            try {
                this.lockFile();
            }
            catch (IOException e) {
                DefaultSystemLog.ERROR().error("lockFile", (Throwable)e);
            }
            JpomManifest jpomManifest = JpomManifest.getInstance();
            File appJpomFile = ConfigBean.getInstance().getApplicationJpomInfo(JpomApplication.getAppType());
            FileUtil.writeString((String)jpomManifest.toString(), (File)appJpomFile, (Charset)CharsetUtil.CHARSET_UTF_8);
            JpomApplicationEvent.checkUpdate();
            if (ApplicationEventLoad.class.isAssignableFrom(JpomApplication.getAppClass())) {
                ApplicationEventLoad eventLoad = (ApplicationEventLoad)SpringUtil.getBean(JpomApplication.getAppClass());
                eventLoad.applicationLoad();
            }
        } else if (event instanceof ContextClosedEvent) {
            this.unLockFile();
            FileUtil.del((File)ConfigBean.getInstance().getPidFile());
            File appJpomFile = ConfigBean.getInstance().getApplicationJpomInfo(JpomApplication.getAppType());
            FileUtil.del((File)appJpomFile);
        }
    }

    private void unLockFile() {
        if (this.lock != null) {
            try {
                this.lock.release();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        IoUtil.close((AutoCloseable)this.lock);
        IoUtil.close((Closeable)this.fileChannel);
        IoUtil.close((Closeable)this.fileOutputStream);
    }

    private void lockFile() throws IOException {
        this.fileOutputStream = new FileOutputStream(ConfigBean.getInstance().getPidFile(), true);
        this.fileChannel = this.fileOutputStream.getChannel();
        while (true) {
            try {
                this.lock = this.fileChannel.lock();
            }
            catch (IOException | OverlappingFileLockException exception) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            break;
        }
    }

    private static void checkPath() {
        String path = ExtConfigBean.getInstance().getPath();
        String extConfigPath = null;
        try {
            extConfigPath = ExtConfigBean.getResource().getURL().toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file = FileUtil.file((String)path);
        try {
            FileUtil.mkdir((File)file);
            file = FileUtil.createTempFile((String)"jpom", (String)".temp", (File)file, (boolean)true);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error(StrUtil.format((CharSequence)"Jpom\u521b\u5efa\u6570\u636e\u76ee\u5f55\u5931\u8d25,\u76ee\u5f55\u4f4d\u7f6e\uff1a{},\u8bf7\u68c0\u67e5\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u6b64\u76ee\u5f55\u6743\u9650\u6216\u4fee\u6539\u914d\u7f6e\u6587\u4ef6\uff1a{}\u4e2d\u7684jpom.path\u4e3a\u53ef\u521b\u5efa\u76ee\u5f55\u7684\u8def\u5f84", (Object[])new Object[]{path, extConfigPath}), (Throwable)e);
            System.exit(-1);
        }
        FileUtil.del((File)file);
        DefaultSystemLog.LOG().info("Jpom[{}]\u5916\u90e8\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)JpomManifest.getInstance().getVersion(), (Object)extConfigPath);
    }

    private static void checkUpdate() {
        File runFile = JpomManifest.getRunPath().getParentFile();
        String upgrade = FileUtil.file((File)runFile, (String)"upgrade.json").getAbsolutePath();
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)JsonFileUtil.readJson(upgrade);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (jsonObject == null) {
            return;
        }
        String beforeJar = jsonObject.getString("beforeJar");
        if (StrUtil.isEmpty((CharSequence)beforeJar)) {
            return;
        }
        File beforeJarFile = FileUtil.file((File)runFile, (String)beforeJar);
        if (beforeJarFile.exists()) {
            File oldJars = FileUtil.file((File)runFile, (String)"oldJars");
            FileUtil.mkdir((File)oldJars);
            FileUtil.move((File)beforeJarFile, (File)oldJars, (boolean)true);
            DefaultSystemLog.LOG().info("\u5907\u4efd\u65e7\u7a0b\u5e8f\u5305\uff1a" + beforeJar);
        }
    }
}

