/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.common;

import cn.hutool.core.util.ClassUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.jpom.common.BaseDataService;
import io.jpom.model.BaseJsonModel;
import io.jpom.model.BaseModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class BaseOperService<T extends BaseModel>
extends BaseDataService {
    private String fileName;
    private Class<?> typeArgument;

    public BaseOperService(String fileName) {
        this.fileName = fileName;
        this.typeArgument = ClassUtil.getTypeArgument(this.getClass());
    }

    public List<T> list() {
        Objects.requireNonNull(this.fileName, "\u6ca1\u6709\u914d\u7f6efileName");
        return this.list(this.typeArgument);
    }

    public <E> List<E> list(Class<E> cls) {
        Objects.requireNonNull(this.fileName, "\u6ca1\u6709\u914d\u7f6efileName");
        JSONObject jsonObject = this.getJSONObject(this.fileName);
        if (jsonObject == null) {
            return new ArrayList();
        }
        JSONArray jsonArray = this.formatToArray(jsonObject);
        return jsonArray.toJavaList(cls);
    }

    public T getItem(String id) {
        Objects.requireNonNull(this.fileName, "\u6ca1\u6709\u914d\u7f6efileName");
        return (T)((BaseModel)this.getJsonObjectById(this.fileName, id, this.typeArgument));
    }

    public void addItem(T t) {
        Objects.requireNonNull(this.fileName, "\u6ca1\u6709\u914d\u7f6efileName");
        this.saveJson(this.fileName, ((BaseJsonModel)t).toJson());
    }

    public void deleteItem(String id) {
        Objects.requireNonNull(this.fileName, "\u6ca1\u6709\u914d\u7f6efileName");
        this.deleteJson(this.fileName, id);
    }

    public void updateItem(T t) {
        Objects.requireNonNull(this.fileName, "\u6ca1\u6709\u914d\u7f6efileName");
        this.updateJson(this.fileName, ((BaseJsonModel)t).toJson());
    }

    private JSONArray formatToArray(JSONObject jsonObject) {
        if (jsonObject == null) {
            return new JSONArray();
        }
        Set setKey = jsonObject.keySet();
        JSONArray jsonArray = new JSONArray();
        for (String key : setKey) {
            jsonArray.add((Object)jsonObject.getJSONObject(key));
        }
        return jsonArray;
    }
}

