/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.jpom.system.ConfigBean;
import io.jpom.system.JpomRuntimeException;
import io.jpom.util.JsonFileUtil;
import java.io.FileNotFoundException;
import java.util.Map;

public abstract class BaseDataService {
    protected String getDataFilePath(String filename) {
        return FileUtil.normalize((String)(ConfigBean.getInstance().getDataPath() + "/" + filename));
    }

    protected void saveJson(String filename, JSONObject json) {
        String key = json.getString("id");
        JSONObject data = null;
        JSONObject allData = this.getJSONObject(filename);
        if (allData != null) {
            data = allData.getJSONObject(key);
        } else {
            allData = new JSONObject();
        }
        if (null != data && 0 < data.keySet().size()) {
            throw new JpomRuntimeException("\u6570\u636eId\u5df2\u7ecf\u5b58\u5728\u5566\uff1a" + filename + " :" + key);
        }
        allData.put(key, (Object)json);
        JsonFileUtil.saveJson(this.getDataFilePath(filename), (JSON)allData);
    }

    protected void updateJson(String filename, JSONObject json) {
        String key = json.getString("id");
        JSONObject allData = this.getJSONObject(filename);
        JSONObject data = allData.getJSONObject(key);
        if (null == data || 0 == data.keySet().size()) {
            throw new JpomRuntimeException("\u6570\u636e\u4e0d\u5b58\u5728:" + key);
        }
        allData.put(key, (Object)json);
        JsonFileUtil.saveJson(this.getDataFilePath(filename), (JSON)allData);
    }

    protected void deleteJson(String filename, String key) {
        JSONObject allData = this.getJSONObject(filename);
        JSONObject data = allData.getJSONObject(key);
        if (CollUtil.isEmpty((Map)data)) {
            throw new JpomRuntimeException("\u9879\u76ee\u540d\u79f0\u5b58\u4e0d\u5728\uff01");
        }
        allData.remove((Object)key);
        JsonFileUtil.saveJson(this.getDataFilePath(filename), (JSON)allData);
    }

    protected JSONObject getJSONObject(String filename) {
        try {
            return (JSONObject)JsonFileUtil.readJson(this.getDataFilePath(filename));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    protected <T> T getJsonObjectById(String file, String id, Class<T> cls) {
        if (StrUtil.isEmpty((CharSequence)id)) {
            return null;
        }
        JSONObject jsonObject = this.getJSONObject(file);
        if (jsonObject == null) {
            return null;
        }
        if ((jsonObject = jsonObject.getJSONObject(id)) == null) {
            return null;
        }
        return (T)jsonObject.toJavaObject(cls);
    }
}

