/*
 * Decompiled with CFR 0.152.
 */
package io.jpom;

import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import com.sun.tools.attach.VirtualMachine;
import io.jpom.util.CommandUtil;
import io.jpom.util.JvmUtil;
import io.jpom.util.StringUtil;
import java.io.IOException;

public class JpomClose {
    private static JpomClose jpomManager;

    public void main(String[] args) throws Exception {
        String tag = StringUtil.getArgsValue(args, "jpom.applicationTag");
        if (StrUtil.isEmpty((CharSequence)tag)) {
            return;
        }
        String event = StringUtil.getArgsValue(args, "event");
        if ("stop".equalsIgnoreCase(event)) {
            String status = JpomClose.getInstance().status(tag);
            if (!status.contains(":")) {
                Console.error((Object)"Jpom\u5e76\u6ca1\u6709\u8fd0\u884c");
            } else {
                String msg = JpomClose.getInstance().stop(tag);
                Console.log((Object)msg);
            }
            System.exit(0);
        } else if ("status".equalsIgnoreCase(event)) {
            String status = JpomClose.getInstance().status(tag);
            Console.log((Object)status);
            System.exit(0);
        }
    }

    public static JpomClose getInstance() {
        if (jpomManager != null) {
            return jpomManager;
        }
        jpomManager = SystemUtil.getOsInfo().isLinux() ? new Linux() : new Windows();
        return jpomManager;
    }

    public String stop(String tag) throws IOException {
        VirtualMachine virtualMachine = JvmUtil.getVirtualMachine(tag);
        if (virtualMachine == null) {
            return null;
        }
        return virtualMachine.id();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String status(String tag) throws IOException {
        VirtualMachine virtualMachine = JvmUtil.getVirtualMachine(tag);
        if (virtualMachine == null) {
            return "Jpom\u5e76\u6ca1\u6709\u8fd0\u884c";
        }
        try {
            String string = "Jpom\u8fd0\u884c\u4e2d:" + virtualMachine.id();
            return string;
        }
        finally {
            virtualMachine.detach();
        }
    }

    private static class Linux
    extends JpomClose {
        private Linux() {
        }

        @Override
        public String stop(String tag) throws IOException {
            String pid = super.stop(tag);
            if (pid == null) {
                return "stop";
            }
            String cmd = String.format("kill  %s", pid);
            return CommandUtil.execSystemCommand(cmd);
        }
    }

    private static class Windows
    extends JpomClose {
        private Windows() {
        }

        @Override
        public String stop(String tag) throws IOException {
            String pid = super.stop(tag);
            if (pid == null) {
                return "stop";
            }
            String cmd = String.format("taskkill /F /PID %s", pid);
            return CommandUtil.execSystemCommand(cmd);
        }
    }
}

