/*
 * Decompiled with CFR 0.152.
 */
package io.jpom;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.system.SystemUtil;
import cn.jiangzeyin.common.ApplicationBuilder;
import cn.jiangzeyin.common.validator.ParameterInterceptor;
import io.jpom.JpomClose;
import io.jpom.common.JpomApplicationEvent;
import io.jpom.common.JpomManifest;
import io.jpom.common.Type;
import io.jpom.common.interceptor.PluginFeatureInterceptor;
import io.jpom.plugin.PluginFactory;
import io.jpom.util.CommandUtil;
import java.io.File;
import java.nio.charset.Charset;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;

public class JpomApplication
extends ApplicationBuilder {
    public static final String SYSTEM_ID = "system";
    protected static String[] args;
    private static Type appType;
    private static Charset charset;
    private static Class<?> appClass;

    public static String[] getArgs() {
        return args;
    }

    public JpomApplication(Type appType, Class<?> appClass, String[] args) throws Exception {
        super(new Class[]{appClass});
        this.checkEvent(args);
        JpomApplication.appType = appType;
        JpomApplication.appClass = appClass;
        JpomApplication.args = args;
        this.addHttpMessageConverter((HttpMessageConverter)new StringHttpMessageConverter(CharsetUtil.CHARSET_UTF_8));
        this.addInterceptor(ParameterInterceptor.class);
        this.addInterceptor(PluginFeatureInterceptor.class);
        this.addApplicationEventClient(new JpomApplicationEvent());
        this.application().addInitializers(new ApplicationContextInitializer[]{new PluginFactory()});
    }

    private void checkEvent(String[] args) throws Exception {
        new JpomClose().main(args);
    }

    public static Charset getCharset() {
        if (charset == null) {
            charset = SystemUtil.getOsInfo().isLinux() ? CharsetUtil.CHARSET_UTF_8 : (SystemUtil.getOsInfo().isMac() ? CharsetUtil.CHARSET_UTF_8 : CharsetUtil.CHARSET_GBK);
        }
        return charset;
    }

    public static Type getAppType() {
        return appType;
    }

    public static Class<?> getAppClass() {
        if (appClass == null) {
            return JpomApplication.class;
        }
        return appClass;
    }

    public static void restart() {
        File scriptFile = JpomManifest.getScriptFile();
        ThreadUtil.execute(() -> {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                CommandUtil.asyncExeLocalCommand(scriptFile.getParentFile(), FileUtil.getAbsolutePath((File)scriptFile) + " restart upgrade");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

