/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.jpom.util.StringUtil;
import java.io.File;

public class FileUtils {
    private static JSONObject fileToJson(File file) {
        JSONObject jsonObject = new JSONObject(6);
        if (file.isDirectory()) {
            jsonObject.put("isDirectory", (Object)true);
            long sizeFile = FileUtil.size((File)file);
            jsonObject.put("fileSize", (Object)FileUtil.readableFileSize((long)sizeFile));
        } else {
            jsonObject.put("fileSize", (Object)FileUtil.readableFileSize((long)file.length()));
        }
        jsonObject.put("filename", (Object)file.getName());
        long mTime = file.lastModified();
        jsonObject.put("modifyTimeLong", (Object)mTime);
        jsonObject.put("modifyTime", (Object)DateUtil.date((long)mTime).toString());
        return jsonObject;
    }

    public static JSONArray parseInfo(File[] files, boolean time, String startPath) {
        int size = files.length;
        JSONArray arrayFile = new JSONArray(size);
        for (File file : files) {
            JSONObject jsonObject = FileUtils.fileToJson(file);
            if (startPath != null) {
                String levelName = StringUtil.delStartPath((File)file, (String)startPath, (boolean)false);
                jsonObject.put("levelName", (Object)levelName);
            }
            arrayFile.add((Object)jsonObject);
        }
        arrayFile.sort((o1, o2) -> {
            JSONObject jsonObject1 = (JSONObject)o1;
            JSONObject jsonObject2 = (JSONObject)o2;
            if (time) {
                return jsonObject2.getLong("modifyTimeLong").compareTo(jsonObject1.getLong("modifyTimeLong"));
            }
            return jsonObject1.getString("filename").compareTo(jsonObject2.getString("filename"));
        });
        int[] i = new int[]{0};
        arrayFile.forEach(o -> {
            JSONObject jsonObject = (JSONObject)o;
            i[0] = i[0] + 1;
            jsonObject.put("index", (Object)i[0]);
        });
        return arrayFile;
    }
}

