/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.util;

import cn.hutool.core.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class CompressionFileUtil {
    private static int BUFFER_SIZE = 2048;

    private static List<String> unTar(File tarFile, File destDir) throws Exception {
        return CompressionFileUtil.unTar(new FileInputStream(tarFile), destDir);
    }

    private static List<String> unTarBZip2(File tarFile, File destDir) throws Exception {
        return CompressionFileUtil.unTar((InputStream)new BZip2CompressorInputStream((InputStream)new FileInputStream(tarFile)), destDir);
    }

    private static List<String> unTarGZ(File tarFile, File destDir) throws Exception {
        return CompressionFileUtil.unTar((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(tarFile))), destDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> unTar(InputStream inputStream, File destDir) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        TarArchiveInputStream tarIn = new TarArchiveInputStream(inputStream, BUFFER_SIZE, "GBK");
        try {
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextTarEntry()) != null) {
                fileNames.add(entry.getName());
                if (entry.isDirectory()) {
                    FileUtil.mkdir((File)new File(destDir, entry.getName()));
                    continue;
                }
                File tmpFile = new File(destDir, entry.getName());
                FileUtil.mkParentDirs((File)destDir);
                FileOutputStream out = null;
                try {
                    int length;
                    out = new FileOutputStream(tmpFile);
                    byte[] b = new byte[2048];
                    while ((length = tarIn.read(b)) != -1) {
                        ((OutputStream)out).write(b, 0, length);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                    return fileNames;
                }
                IOUtils.closeQuietly((Closeable)out);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)tarIn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> unBZip2(File srcFile, File destDir) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        BZip2CompressorInputStream is = null;
        BufferedOutputStream os = null;
        try {
            String name = srcFile.getName().replace(".bz2", "");
            File destFile = new File(destDir, name);
            fileNames.add(srcFile.getName());
            is = new BZip2CompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(srcFile), BUFFER_SIZE));
            os = new BufferedOutputStream(new FileOutputStream(destFile), BUFFER_SIZE);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)os);
        IOUtils.closeQuietly((Closeable)is);
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> unGZ(File srcFile, File destDir) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        GzipCompressorInputStream is = null;
        BufferedOutputStream os = null;
        try {
            String name = srcFile.getName().replace(".gz", "");
            File destFile = new File(destDir, name);
            fileNames.add(srcFile.getName());
            os = new BufferedOutputStream(new FileOutputStream(destFile), BUFFER_SIZE);
            is = new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(srcFile), BUFFER_SIZE));
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)os);
        IOUtils.closeQuietly((Closeable)is);
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> unZip(File zipfile, File destDir) throws Exception {
        ZipArchiveInputStream is = null;
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            ZipArchiveEntry entry;
            is = new ZipArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(zipfile), BUFFER_SIZE), "GBK");
            while ((entry = is.getNextZipEntry()) != null) {
                fileNames.add(entry.getName());
                if (entry.isDirectory()) {
                    FileUtil.mkdir((File)new File(destDir, entry.getName()));
                    continue;
                }
                File file = new File(destDir, entry.getName());
                FileUtil.mkParentDirs((File)file);
                BufferedOutputStream os = null;
                try {
                    os = new BufferedOutputStream(new FileOutputStream(file), BUFFER_SIZE);
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)os);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)is);
        return fileNames;
    }

    public static List<String> unCompress(File compressFile, File destDir) throws Exception {
        String upperName = FileUtil.getName((File)compressFile).toUpperCase();
        List<String> ret = null;
        if (upperName.endsWith(".ZIP")) {
            ret = CompressionFileUtil.unZip(compressFile, destDir);
        } else if (upperName.endsWith(".TAR")) {
            ret = CompressionFileUtil.unTar(compressFile, destDir);
        } else if (upperName.endsWith(".TAR.BZ2")) {
            ret = CompressionFileUtil.unTarBZip2(compressFile, destDir);
        } else if (upperName.endsWith(".BZ2")) {
            ret = CompressionFileUtil.unBZip2(compressFile, destDir);
        } else if (upperName.endsWith(".TAR.GZ")) {
            ret = CompressionFileUtil.unTarGZ(compressFile, destDir);
        } else if (upperName.endsWith(".GZ")) {
            ret = CompressionFileUtil.unGZ(compressFile, destDir);
        }
        return ret;
    }
}

