/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.system.init;

import ch.qos.logback.core.util.FileSize;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.PreLoadClass;
import cn.jiangzeyin.common.PreLoadMethod;
import cn.jiangzeyin.common.spring.SpringUtil;
import io.jpom.common.commander.AbstractProjectCommander;
import io.jpom.model.data.ProjectInfoModel;
import io.jpom.service.manage.ProjectInfoService;
import io.jpom.system.AgentExtConfigBean;
import io.jpom.util.CronUtils;
import java.io.File;
import java.util.Date;
import java.util.List;

@PreLoadClass
public class AutoBackLog {
    private static final String ID = "auto_back_log";
    private static ProjectInfoService projectInfoService;
    private static FileSize MAX_SIZE;

    @PreLoadMethod
    private static void startAutoBackLog() {
        String cron;
        if (projectInfoService == null) {
            projectInfoService = (ProjectInfoService)((Object)SpringUtil.getBean(ProjectInfoService.class));
        }
        if ("none".equalsIgnoreCase((cron = StrUtil.emptyToDefault((CharSequence)AgentExtConfigBean.getInstance().autoBackConsoleCron, (String)"none")).trim())) {
            DefaultSystemLog.LOG().info("\u6ca1\u6709\u914d\u7f6e\u81ea\u52a8\u5907\u4efd\u63a7\u5236\u53f0\u65e5\u5fd7\u8868\u8fbe\u5f0f");
            return;
        }
        String size = StrUtil.emptyToDefault((CharSequence)AgentExtConfigBean.getInstance().autoBackSize, (String)"50MB");
        MAX_SIZE = FileSize.valueOf((String)size.trim());
        CronUtil.schedule((String)ID, (String)cron, () -> {
            try {
                List list = projectInfoService.list();
                if (list == null) {
                    return;
                }
                list.forEach(projectInfoModel -> {
                    String log = projectInfoModel.getLog();
                    File file = new File(log);
                    if (!file.exists()) {
                        return;
                    }
                    long len = file.length();
                    if (len > MAX_SIZE.getSize()) {
                        try {
                            AbstractProjectCommander.getInstance().backLog((ProjectInfoModel)((Object)((Object)projectInfoModel)));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    File logFile = projectInfoModel.getLogBack();
                    DateTime nowTime = DateTime.now();
                    List files = FileUtil.loopFiles((File)logFile, pathname -> {
                        long saveDays;
                        DateTime dateTime = DateUtil.date((long)pathname.lastModified());
                        long days = DateUtil.betweenDay((Date)dateTime, (Date)nowTime, (boolean)false);
                        return days > (saveDays = (long)AgentExtConfigBean.getInstance().getLogSaveDays());
                    });
                    files.forEach(FileUtil::del);
                });
            }
            catch (Exception e) {
                DefaultSystemLog.ERROR().error("\u5b9a\u65f6\u5907\u4efd\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
        });
        CronUtils.start();
    }
}

