/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.system;

import cn.hutool.cache.impl.CacheObj;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.pool.ThreadPoolService;
import com.alibaba.fastjson.JSONObject;
import io.jpom.common.commander.AbstractSystemCommander;
import io.jpom.model.system.ProcessModel;
import io.jpom.util.CronUtils;
import io.jpom.util.SocketSessionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.Session;

public class TopManager {
    private static final Set<Session> SESSIONS = new HashSet<Session>();
    private static final String CRON_ID = "topMonitor";
    private static ExecutorService executorService = ThreadPoolService.newCachedThreadPool(TopManager.class);
    private static final TimedCache<String, JSONObject> MONITOR_CACHE = new TimedCache(TimeUnit.MINUTES.toMillis(12L), new LinkedHashMap());
    private static final AtomicBoolean WATCH = new AtomicBoolean(false);

    public static void addMonitor(Session session) {
        SESSIONS.add(session);
        TopManager.addCron();
    }

    public static void removeMonitor(Session session) {
        SESSIONS.remove(session);
        TopManager.close();
    }

    private static void addCron() {
        if (WATCH.get()) {
            return;
        }
        CronUtil.remove((String)CRON_ID);
        CronUtil.schedule((String)CRON_ID, (String)"0/30 * * * * ?", () -> {
            try {
                JSONObject topInfo = AbstractSystemCommander.getInstance().getAllMonitor();
                if (topInfo != null) {
                    String time = DateUtil.formatTime((Date)DateUtil.date());
                    topInfo.put("time", (Object)time);
                    MONITOR_CACHE.put((Object)time, (Object)topInfo);
                    TopManager.send(topInfo.toString());
                }
            }
            catch (Exception e) {
                DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
            }
            TopManager.sendProcessList();
        });
        CronUtils.start();
        WATCH.set(true);
    }

    public static JSONObject getTopMonitor() {
        String time;
        Iterator cacheObjIterator = MONITOR_CACHE.cacheObjIterator();
        String lastTime = "";
        List<JSONObject> array = new ArrayList();
        ArrayList<String> scale = new ArrayList<String>();
        JSONObject value = null;
        while (cacheObjIterator.hasNext()) {
            CacheObj cacheObj = (CacheObj)cacheObjIterator.next();
            String key = (String)cacheObj.getKey();
            if (StrUtil.isNotEmpty((CharSequence)lastTime) && !key.equals(TopManager.getNextScaleTime(lastTime))) {
                array.clear();
                scale.clear();
            }
            lastTime = key;
            scale.add(key);
            value = (JSONObject)cacheObj.getValue();
            array.add(value);
        }
        if (value != null && !TopManager.getNextScaleTime(time = value.getString("time")).equals(TopManager.getNowNextScale())) {
            array.clear();
            scale.clear();
        }
        int count = 24;
        if (array.size() > count) {
            array = array.subList(array.size() - count - 1, array.size() - 1);
        }
        while (scale.size() < count) {
            if (scale.size() == 0) {
                scale.add(TopManager.getNowNextScale());
            }
            String time2 = (String)scale.get(scale.size() - 1);
            String newTime = TopManager.getNextScaleTime(time2);
            scale.add(newTime);
        }
        JSONObject object = new JSONObject();
        object.put("scale", scale);
        object.put("series", array);
        return object;
    }

    private static String getNowNextScale() {
        DateTime date = DateUtil.date();
        int second = date.second();
        if (second <= 30 && second > 0) {
            second = 30;
        } else if (second > 30) {
            second = 0;
            date = date.offset(DateField.MINUTE, 1);
        }
        String format = DateUtil.format((Date)date, (String)"HH:mm");
        String secondStr = ":" + second;
        if (second < 10) {
            secondStr = ":0" + second;
        }
        return format + secondStr;
    }

    private static String getNextScaleTime(String time) {
        DateTime dateTime = DateUtil.parseTime((String)time);
        DateTime newTime = dateTime.offsetNew(DateField.SECOND, 30);
        return DateUtil.formatTime((Date)newTime);
    }

    private static void sendProcessList() {
        executorService.execute(() -> {
            List<ProcessModel> array = AbstractSystemCommander.getInstance().getProcessList();
            if (array != null) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("processList", array);
                TopManager.send(jsonObject.toJSONString());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void send(String content) {
        Class<TopManager> clazz = TopManager.class;
        synchronized (TopManager.class) {
            String htmlContent = content.replaceAll("\n", "<br/>");
            htmlContent = htmlContent.replaceAll(" ", "&nbsp;&nbsp;");
            Iterator<Session> iterator = SESSIONS.iterator();
            while (iterator.hasNext()) {
                Session session = iterator.next();
                try {
                    SocketSessionUtil.send((Session)session, (String)htmlContent);
                }
                catch (IOException e) {
                    DefaultSystemLog.ERROR().error("\u6d88\u606f\u5931\u8d25", (Throwable)e);
                    try {
                        session.close();
                        iterator.remove();
                    }
                    catch (IOException iOException) {}
                }
            }
            TopManager.close();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void close() {
        if (SESSIONS.isEmpty()) {
            CronUtil.remove((String)CRON_ID);
            WATCH.set(false);
        }
    }
}

