/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.system;

import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.jiangzeyin.common.spring.SpringUtil;
import io.jpom.system.ConfigBean;
import io.jpom.system.JpomRuntimeException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AgentExtConfigBean {
    private static AgentExtConfigBean agentExtConfigBean;
    @Value(value="${whitelistDirectory.checkStartsWith:true}")
    public boolean whitelistDirectoryCheckStartsWith;
    @Value(value="${log.autoBackConsoleCron:0 0/10 * * * ?}")
    public String autoBackConsoleCron;
    @Value(value="${log.autoBackSize:50MB}")
    public String autoBackSize;
    @Value(value="${log.saveDays:7}")
    private int logSaveDays;
    @Value(value="${jpom.agent.id:}")
    private String agentId;
    @Value(value="${jpom.agent.url:}")
    private String agentUrl;
    @Value(value="${jpom.server.url:}")
    private String serverUrl;
    @Value(value="${jpom.server.token:}")
    private String serverToken;

    public String getAgentId() {
        return this.agentId;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getServerToken() {
        return this.serverToken;
    }

    public String getAgentUrl() {
        if (StrUtil.isEmpty((CharSequence)this.agentUrl)) {
            String localhostStr = NetUtil.getLocalhostStr();
            int port = ConfigBean.getInstance().getPort();
            this.agentUrl = String.format("http://%s:%s", localhostStr, port);
        }
        if (StrUtil.isEmpty((CharSequence)this.agentUrl)) {
            throw new JpomRuntimeException("\u83b7\u53d6Agent url\u5931\u8d25");
        }
        return this.agentUrl;
    }

    public HttpRequest createServerRequest(String openApi) {
        if (StrUtil.isEmpty((CharSequence)this.getServerUrl())) {
            throw new JpomRuntimeException("\u8bf7\u5148\u914d\u7f6eserver\u7aefurl");
        }
        if (StrUtil.isEmpty((CharSequence)this.getServerToken())) {
            throw new JpomRuntimeException("\u8bf7\u5148\u914d\u7f6eserver\u7aefToken");
        }
        String md5 = SecureUtil.md5((String)this.getServerToken());
        md5 = SecureUtil.sha1((String)(md5 + "JPOM-TOKEN"));
        HttpRequest httpRequest = HttpUtil.createPost((String)String.format("%s%s", this.serverUrl, openApi));
        httpRequest.header("JPOM-TOKEN", md5);
        return httpRequest;
    }

    public int getLogSaveDays() {
        if (this.logSaveDays <= 0) {
            return 7;
        }
        return this.logSaveDays;
    }

    public static AgentExtConfigBean getInstance() {
        if (agentExtConfigBean == null) {
            agentExtConfigBean = (AgentExtConfigBean)SpringUtil.getBean(AgentExtConfigBean.class);
        }
        return agentExtConfigBean;
    }
}

