/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.system;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.jpom.model.system.AgentAutoUser;
import io.jpom.system.ConfigBean;
import io.jpom.system.JpomRuntimeException;
import io.jpom.util.JsonFileUtil;
import java.nio.charset.Charset;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AgentAuthorize {
    private static AgentAuthorize agentAuthorize;
    @Value(value="${jpom.authorize.agentName}")
    private String agentName;
    @Value(value="${jpom.authorize.agentPwd:}")
    private String agentPwd;
    private String authorize;

    public static AgentAuthorize getInstance() {
        if (agentAuthorize == null) {
            agentAuthorize = (AgentAuthorize)SpringUtil.getBean(AgentAuthorize.class);
            if (StrUtil.isEmpty((CharSequence)AgentAuthorize.agentAuthorize.agentName)) {
                throw new JpomRuntimeException("agent \u7aef\u767b\u5f55\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            agentAuthorize.checkPwd();
            AgentAuthorize.agentAuthorize.authorize = SecureUtil.sha1((String)(AgentAuthorize.agentAuthorize.agentName + "@" + AgentAuthorize.agentAuthorize.agentPwd));
        }
        return agentAuthorize;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getAgentPwd() {
        return this.agentPwd;
    }

    public boolean checkAuthorize(String authorize) {
        return StrUtil.equals((CharSequence)authorize, (CharSequence)this.authorize);
    }

    private void checkPwd() {
        String path = ConfigBean.getInstance().getAgentAutoAuthorizeFile(ConfigBean.getInstance().getDataPath());
        if (StrUtil.isNotEmpty((CharSequence)this.agentPwd)) {
            FileUtil.del((String)path);
            return;
        }
        if (FileUtil.exist((String)path)) {
            try {
                String json = FileUtil.readString((String)path, (Charset)CharsetUtil.CHARSET_UTF_8);
                AgentAutoUser autoUser = (AgentAutoUser)JSONObject.parseObject((String)json, AgentAutoUser.class);
                String oldAgentPwd = autoUser.getAgentPwd();
                if (!StrUtil.equals((CharSequence)autoUser.getAgentName(), (CharSequence)this.agentName)) {
                    throw new JpomRuntimeException("\u5df2\u7ecf\u5b58\u5728\u7684\u767b\u5f55\u540d\u548c\u914d\u7f6e\u7684\u767b\u5f55\u540d\u4e0d\u4e00\u81f4");
                }
                if (StrUtil.isNotEmpty((CharSequence)oldAgentPwd)) {
                    this.agentPwd = oldAgentPwd;
                    DefaultSystemLog.LOG().info("\u5df2\u6709\u6388\u6743\u8d26\u53f7:{}  \u5bc6\u7801:{},\u6388\u6743\u4fe1\u606f\u4fdd\u5b58\u4f4d\u7f6e\uff1a{}", new Object[]{this.agentName, this.agentPwd, FileUtil.getAbsolutePath((String)path)});
                    return;
                }
            }
            catch (JpomRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.agentPwd = RandomUtil.randomString((int)10);
        AgentAutoUser autoUser = new AgentAutoUser();
        autoUser.setAgentName(this.agentName);
        autoUser.setAgentPwd(this.agentPwd);
        JsonFileUtil.saveJson((String)path, (JSON)autoUser.toJson());
        DefaultSystemLog.LOG().info("\u5df2\u7ecf\u81ea\u52a8\u751f\u6210\u6388\u6743\u8d26\u53f7:{}  \u5bc6\u7801:{},\u6388\u6743\u4fe1\u606f\u4fdd\u5b58\u4f4d\u7f6e\uff1a{}", new Object[]{this.agentName, this.agentPwd, FileUtil.getAbsolutePath((String)path)});
    }
}

