/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.socket;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import com.alibaba.fastjson.JSONObject;
import io.jpom.JpomApplication;
import io.jpom.model.data.ScriptModel;
import io.jpom.socket.ConsoleCommandOp;
import io.jpom.util.SocketSessionUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Session;

public class ScriptProcessBuilder
implements Runnable {
    private static final ConcurrentHashMap<File, ScriptProcessBuilder> FILE_SCRIPT_PROCESS_BUILDER_CONCURRENT_HASH_MAP = new ConcurrentHashMap();
    private ProcessBuilder processBuilder;
    private Set<Session> sessions = new HashSet<Session>();
    private File logFile;
    private File scriptFile;
    private Process process;
    private InputStream inputStream;
    private InputStream errorInputStream;

    private ScriptProcessBuilder(ScriptModel scriptModel, String args) {
        this.logFile = scriptModel.getLogFile(true);
        this.scriptFile = scriptModel.getFile(true);
        String script = FileUtil.getAbsolutePath((File)this.scriptFile);
        this.processBuilder = new ProcessBuilder(new String[0]);
        List command = StrUtil.splitTrim((CharSequence)args, (CharSequence)" ");
        command.add(0, script);
        DefaultSystemLog.LOG().info(CollUtil.join((Iterable)command, (CharSequence)" "));
        this.processBuilder.command(command);
    }

    public static void addWatcher(ScriptModel scriptModel, String args, Session session) {
        File file = scriptModel.getFile(true);
        ScriptProcessBuilder scriptProcessBuilder = FILE_SCRIPT_PROCESS_BUILDER_CONCURRENT_HASH_MAP.computeIfAbsent(file, file1 -> {
            ScriptProcessBuilder scriptProcessBuilder1 = new ScriptProcessBuilder(scriptModel, args);
            ThreadUtil.execute((Runnable)scriptProcessBuilder1);
            return scriptProcessBuilder1;
        });
        if (scriptProcessBuilder.sessions.add(session) && FileUtil.exist((File)scriptProcessBuilder.logFile)) {
            FileUtil.readLines((File)scriptProcessBuilder.logFile, (Charset)CharsetUtil.CHARSET_UTF_8, line -> {
                try {
                    SocketSessionUtil.send((Session)session, (String)line);
                }
                catch (IOException e) {
                    DefaultSystemLog.ERROR().error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
                }
            });
        }
    }

    public static void stopWatcher(Session session) {
        Collection<ScriptProcessBuilder> scriptProcessBuilders = FILE_SCRIPT_PROCESS_BUILDER_CONCURRENT_HASH_MAP.values();
        for (ScriptProcessBuilder scriptProcessBuilder : scriptProcessBuilders) {
            Set<Session> sessions = scriptProcessBuilder.sessions;
            sessions.removeIf(session1 -> session1.getId().equals(session.getId()));
        }
    }

    public static void stopRun(ScriptModel scriptModel) {
        File file = scriptModel.getFile(true);
        ScriptProcessBuilder scriptProcessBuilder = FILE_SCRIPT_PROCESS_BUILDER_CONCURRENT_HASH_MAP.get(file);
        if (scriptProcessBuilder != null) {
            scriptProcessBuilder.end("\u505c\u6b62\u8fd0\u884c");
        }
    }

    @Override
    public void run() {
        try {
            this.process = this.processBuilder.start();
            this.inputStream = this.process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream, JpomApplication.getCharset());
            BufferedReader results = new BufferedReader(inputStreamReader);
            IoUtil.readLines((Reader)results, this::handle);
            this.errorInputStream = this.process.getErrorStream();
            inputStreamReader = new InputStreamReader(this.errorInputStream, JpomApplication.getCharset());
            results = new BufferedReader(inputStreamReader);
            IoUtil.readLines((Reader)results, line -> this.handle("ERROR:" + line));
            JsonMessage jsonMessage = new JsonMessage(200, "\u6267\u884c\u5b8c\u6bd5");
            JSONObject jsonObject = jsonMessage.toJson();
            jsonObject.put("op", (Object)ConsoleCommandOp.stop.name());
            this.end(jsonObject.toString());
        }
        catch (IORuntimeException jsonMessage) {
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u6267\u884c\u5f02\u5e38", (Throwable)e);
            this.end("\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private void end(String msg) {
        if (this.process != null) {
            this.process.destroy();
            IoUtil.close((Closeable)this.inputStream);
            IoUtil.close((Closeable)this.errorInputStream);
        }
        Iterator<Session> iterator = this.sessions.iterator();
        while (iterator.hasNext()) {
            Session session = iterator.next();
            try {
                SocketSessionUtil.send((Session)session, (String)msg);
            }
            catch (IOException e) {
                DefaultSystemLog.ERROR().error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
            }
            iterator.remove();
        }
        FILE_SCRIPT_PROCESS_BUILDER_CONCURRENT_HASH_MAP.remove(this.scriptFile);
    }

    private void handle(String line) {
        ArrayList<String> fileLine = new ArrayList<String>();
        fileLine.add(line);
        FileUtil.appendLines(fileLine, (File)this.logFile, (Charset)CharsetUtil.CHARSET_UTF_8);
        Iterator<Session> iterator = this.sessions.iterator();
        while (iterator.hasNext()) {
            Session session = iterator.next();
            try {
                SocketSessionUtil.send((Session)session, (String)line);
            }
            catch (IOException e) {
                DefaultSystemLog.ERROR().error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
                iterator.remove();
            }
        }
    }
}

