/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.socket;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import io.jpom.socket.AgentFileTailWatcher;
import io.jpom.system.TopManager;
import io.jpom.util.SocketSessionUtil;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Session;

public abstract class BaseAgentWebSocketHandle {
    private static final ConcurrentHashMap<String, String> USER = new ConcurrentHashMap();

    public void addUser(Session session, String name) {
        String optUser = URLUtil.decode((String)name);
        USER.put(session.getId(), optUser);
    }

    public void onError(Session session, Throwable thr) {
        try {
            SocketSessionUtil.send((Session)session, (String)("\u670d\u52a1\u7aef\u53d1\u751f\u5f02\u5e38" + ExceptionUtil.stacktraceToString((Throwable)thr)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DefaultSystemLog.ERROR().error(session.getId() + "socket \u5f02\u5e38", thr);
    }

    protected String getOptUserName(Session session) {
        String name = USER.get(session.getId());
        return StrUtil.emptyToDefault((CharSequence)name, (String)"-");
    }

    public void onClose(Session session) {
        try {
            AgentFileTailWatcher.offline(session);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u5173\u95ed\u5f02\u5e38", (Throwable)e);
        }
        TopManager.removeMonitor(session);
        USER.remove(session.getId());
    }
}

