/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.socket;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.io.FileUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import cn.jiangzeyin.common.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import io.jpom.model.data.TomcatInfoModel;
import io.jpom.service.manage.TomcatEditService;
import io.jpom.socket.AgentFileTailWatcher;
import io.jpom.socket.BaseAgentWebSocketHandle;
import io.jpom.socket.ConsoleCommandOp;
import io.jpom.system.WebAopLog;
import io.jpom.util.SocketSessionUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/tomcat_log/{tomcatId}/{optUser}")
@Component
public class AgentWebSocketTomcatHandle
extends BaseAgentWebSocketHandle {
    private TomcatEditService tomcatEditService;
    private static final Map<String, File> CACHE_FILE = new ConcurrentHashMap<String, File>();

    @OnOpen
    public void onOpen(@PathParam(value="tomcatId") String tomcatId, @PathParam(value="optUser") String urlOptUser, Session session) {
        try {
            TomcatInfoModel tomcatInfoModel;
            if (this.tomcatEditService == null) {
                this.tomcatEditService = (TomcatEditService)((Object)SpringUtil.getBean(TomcatEditService.class));
            }
            if ((tomcatInfoModel = (TomcatInfoModel)this.tomcatEditService.getItem(tomcatId)) == null && !"system".equalsIgnoreCase(tomcatId)) {
                SocketSessionUtil.send((Session)session, (String)"\u83b7\u53d6tomcat\u4fe1\u606f\u9519\u8bef");
                session.close();
                return;
            }
            this.addUser(session, urlOptUser);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("socket \u9519\u8bef", (Throwable)e);
            try {
                SocketSessionUtil.send((Session)session, (String)JsonMessage.getString((int)500, (String)"\u7cfb\u7edf\u9519\u8bef!"));
                session.close();
            }
            catch (IOException e1) {
                DefaultSystemLog.ERROR().error(e1.getMessage(), (Throwable)e1);
            }
        }
    }

    @OnMessage
    public void onMessage(String message, Session session) throws Exception {
        JSONObject json = JSONObject.parseObject((String)message);
        String op = json.getString("op");
        ConsoleCommandOp consoleCommandOp = ConsoleCommandOp.valueOf((String)op);
        if (consoleCommandOp == ConsoleCommandOp.heart) {
            return;
        }
        String tomcatId = json.getString("tomcatId");
        if ("system".equalsIgnoreCase(tomcatId)) {
            this.runMsg(session, json);
        } else {
            TomcatInfoModel tomcatInfoModel = (TomcatInfoModel)this.tomcatEditService.getItem(tomcatId);
            if (tomcatInfoModel == null) {
                SocketSessionUtil.send((Session)session, (String)"\u6ca1\u6709\u5bf9\u5e94tomcat");
                session.close();
                return;
            }
            this.runMsg(session, tomcatInfoModel, json);
        }
    }

    private void runMsg(Session session, JSONObject reqJson) throws Exception {
        try {
            String fileName = reqJson.getString("fileName");
            WebAopLog webAopLog = (WebAopLog)SpringUtil.getBean(WebAopLog.class);
            File file = FileUtil.file((String)webAopLog.getPropertyValue(), (String)fileName);
            File file1 = CACHE_FILE.get(session.getId());
            if (file1 != null && !file1.equals(file)) {
                AgentFileTailWatcher.offlineFile(file, session);
            }
            try {
                AgentFileTailWatcher.addWatcher(file, session);
                CACHE_FILE.put(session.getId(), file);
            }
            catch (IOException io) {
                DefaultSystemLog.ERROR().error("\u76d1\u542c\u65e5\u5fd7\u53d8\u5316", (Throwable)io);
                SocketSessionUtil.send((Session)session, (String)io.getMessage());
            }
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u6267\u884c\u547d\u4ee4\u5931\u8d25", (Throwable)e);
            SocketSessionUtil.send((Session)session, (String)"\u6267\u884c\u547d\u4ee4\u5931\u8d25,\u8be6\u60c5\u5982\u4e0b\uff1a");
            SocketSessionUtil.send((Session)session, (String)ExceptionUtil.stacktraceToString((Throwable)e));
        }
    }

    private void runMsg(Session session, TomcatInfoModel tomcatInfoModel, JSONObject reqJson) throws Exception {
        try {
            String fileName = reqJson.getString("fileName");
            File file = FileUtil.file((String[])new String[]{tomcatInfoModel.getPath(), "logs", fileName});
            try {
                AgentFileTailWatcher.addWatcher(file, session);
            }
            catch (IOException io) {
                DefaultSystemLog.ERROR().error("\u76d1\u542c\u65e5\u5fd7\u53d8\u5316", (Throwable)io);
                SocketSessionUtil.send((Session)session, (String)io.getMessage());
            }
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u6267\u884c\u547d\u4ee4\u5931\u8d25", (Throwable)e);
            SocketSessionUtil.send((Session)session, (String)"\u6267\u884c\u547d\u4ee4\u5931\u8d25,\u8be6\u60c5\u5982\u4e0b\uff1a");
            SocketSessionUtil.send((Session)session, (String)ExceptionUtil.stacktraceToString((Throwable)e));
        }
    }

    @Override
    @OnClose
    public void onClose(Session session) {
        super.onClose(session);
    }

    @Override
    @OnError
    public void onError(Session session, Throwable thr) {
        super.onError(session, thr);
    }
}

