/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.socket;

import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import cn.jiangzeyin.common.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import io.jpom.model.data.ScriptModel;
import io.jpom.service.script.ScriptServer;
import io.jpom.socket.BaseAgentWebSocketHandle;
import io.jpom.socket.ConsoleCommandOp;
import io.jpom.socket.ScriptProcessBuilder;
import io.jpom.util.SocketSessionUtil;
import java.io.IOException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/script_run/{id}/{optUser}")
@Component
public class AgentWebSocketScriptHandle
extends BaseAgentWebSocketHandle {
    private ScriptServer scriptServer;

    @OnOpen
    public void onOpen(@PathParam(value="id") String id, Session session, @PathParam(value="optUser") String urlOptUser) {
        if (this.scriptServer == null) {
            this.scriptServer = (ScriptServer)((Object)SpringUtil.getBean(ScriptServer.class));
        }
        try {
            if (StrUtil.isEmpty((CharSequence)id)) {
                SocketSessionUtil.send((Session)session, (String)"\u811a\u672c\u6a21\u677f\u672a\u77e5");
                return;
            }
            ScriptModel scriptModel = this.scriptServer.getItem(id);
            if (scriptModel == null) {
                SocketSessionUtil.send((Session)session, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u811a\u672c\u6a21\u677f");
                return;
            }
            SocketSessionUtil.send((Session)session, (String)("\u8fde\u63a5\u6210\u529f\uff1a" + scriptModel.getName()));
            this.addUser(session, urlOptUser);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("socket \u9519\u8bef", (Throwable)e);
            try {
                SocketSessionUtil.send((Session)session, (String)JsonMessage.getString((int)500, (String)"\u7cfb\u7edf\u9519\u8bef!"));
                session.close();
            }
            catch (IOException e1) {
                DefaultSystemLog.ERROR().error(e1.getMessage(), (Throwable)e1);
            }
        }
    }

    @OnMessage
    public void onMessage(String message, Session session) throws Exception {
        JSONObject json = JSONObject.parseObject((String)message);
        String scriptId = json.getString("scriptId");
        ScriptModel scriptModel = this.scriptServer.getItem(scriptId);
        if (scriptModel == null) {
            SocketSessionUtil.send((Session)session, (String)("\u6ca1\u6709\u5bf9\u5e94\u811a\u672c\u6a21\u677f:" + scriptId));
            session.close();
            return;
        }
        String op = json.getString("op");
        ConsoleCommandOp consoleCommandOp = ConsoleCommandOp.valueOf((String)op);
        switch (consoleCommandOp) {
            case start: {
                String args = json.getString("args");
                ScriptProcessBuilder.addWatcher(scriptModel, args, session);
                break;
            }
            case stop: {
                ScriptProcessBuilder.stopRun(scriptModel);
                break;
            }
            default: {
                return;
            }
        }
        scriptModel = this.scriptServer.getItem(scriptId);
        String name = this.getOptUserName(session);
        scriptModel.setLastRunUser(name);
        this.scriptServer.updateItem(scriptModel);
        json.put("code", (Object)200);
        json.put("msg", (Object)"\u6267\u884c\u6210\u529f");
        DefaultSystemLog.LOG().info(json.toString());
        SocketSessionUtil.send((Session)session, (String)json.toString());
    }

    @Override
    @OnClose
    public void onClose(Session session) {
        super.onClose(session);
        ScriptProcessBuilder.stopWatcher(session);
    }

    @Override
    @OnError
    public void onError(Session session, Throwable thr) {
        super.onError(session, thr);
    }
}

