/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.socket;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import cn.jiangzeyin.common.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import io.jpom.model.data.ProjectInfoModel;
import io.jpom.service.manage.ConsoleService;
import io.jpom.service.manage.ProjectInfoService;
import io.jpom.socket.AgentFileTailWatcher;
import io.jpom.socket.BaseAgentWebSocketHandle;
import io.jpom.socket.ConsoleCommandOp;
import io.jpom.system.TopManager;
import io.jpom.util.SocketSessionUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/console/{projectId}/{optUser}")
@Component
public class AgentWebSocketConsoleHandle
extends BaseAgentWebSocketHandle {
    private static ProjectInfoService projectInfoService;

    @OnOpen
    public void onOpen(@PathParam(value="projectId") String projectId, @PathParam(value="optUser") String urlOptUser, Session session) {
        try {
            if (!"system".equals(projectId)) {
                ProjectInfoModel projectInfoModel;
                if (projectInfoService == null) {
                    projectInfoService = (ProjectInfoService)((Object)SpringUtil.getBean(ProjectInfoService.class));
                }
                if ((projectInfoModel = (ProjectInfoModel)projectInfoService.getItem(projectId)) == null) {
                    SocketSessionUtil.send((Session)session, (String)"\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u9519\u8bef");
                    session.close();
                    return;
                }
            }
            this.addUser(session, urlOptUser);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("socket \u9519\u8bef", (Throwable)e);
            try {
                SocketSessionUtil.send((Session)session, (String)JsonMessage.getString((int)500, (String)"\u7cfb\u7edf\u9519\u8bef!"));
                session.close();
            }
            catch (IOException e1) {
                DefaultSystemLog.ERROR().error(e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private boolean silentMsg(ConsoleCommandOp consoleCommandOp, Session session) {
        if (consoleCommandOp == ConsoleCommandOp.heart) {
            return true;
        }
        if (consoleCommandOp == ConsoleCommandOp.top) {
            TopManager.addMonitor(session);
            return true;
        }
        return false;
    }

    @OnMessage
    public void onMessage(String message, Session session) throws Exception {
        JSONObject json = JSONObject.parseObject((String)message);
        String op = json.getString("op");
        ConsoleCommandOp consoleCommandOp = ConsoleCommandOp.valueOf((String)op);
        if (this.silentMsg(consoleCommandOp, session)) {
            return;
        }
        String projectId = json.getString("projectId");
        ProjectInfoModel projectInfoModel = (ProjectInfoModel)projectInfoService.getItem(projectId);
        if (projectInfoModel == null) {
            SocketSessionUtil.send((Session)session, (String)"\u6ca1\u6709\u5bf9\u5e94\u9879\u76ee");
            session.close();
            return;
        }
        this.runMsg(consoleCommandOp, session, projectInfoModel, json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runMsg(ConsoleCommandOp consoleCommandOp, Session session, ProjectInfoModel projectInfoModel, JSONObject reqJson) throws Exception {
        consoleService = (ConsoleService)SpringUtil.getBean(ConsoleService.class);
        resultData = null;
        logUser = false;
        try {
            switch (1.$SwitchMap$io$jpom$socket$ConsoleCommandOp[consoleCommandOp.ordinal()]) {
                case 1: 
                case 2: {
                    logUser = true;
                    strResult = consoleService.execCommand(consoleCommandOp, projectInfoModel);
                    if (strResult.contains("running")) {
                        resultData = JsonMessage.toJson((int)200, (String)("\u64cd\u4f5c\u6210\u529f:" + strResult));
                        ** break;
lbl12:
                        // 1 sources

                    } else {
                        resultData = JsonMessage.toJson((int)400, (String)strResult);
                        ** break;
                    }
lbl15:
                    // 1 sources

                    break;
                }
                case 3: {
                    logUser = true;
                    strResult = consoleService.execCommand(consoleCommandOp, projectInfoModel);
                    if (strResult.contains("stopped")) {
                        resultData = JsonMessage.toJson((int)200, (String)"\u64cd\u4f5c\u6210\u529f");
                        ** break;
lbl22:
                        // 1 sources

                    } else {
                        resultData = JsonMessage.toJson((int)500, (String)strResult);
                        ** break;
                    }
lbl25:
                    // 1 sources

                    break;
                }
                case 4: {
                    strResult = consoleService.execCommand(consoleCommandOp, projectInfoModel);
                    if (strResult.contains("running")) {
                        resultData = JsonMessage.toJson((int)200, (String)"\u8fd0\u884c\u4e2d", (Object)strResult);
                        ** break;
lbl31:
                        // 1 sources

                    } else {
                        resultData = JsonMessage.toJson((int)404, (String)"\u672a\u8fd0\u884c", (Object)strResult);
                        ** break;
                    }
lbl34:
                    // 1 sources

                    break;
                }
                case 5: {
                    file = new File(projectInfoModel.getLog());
                    try {
                        AgentFileTailWatcher.addWatcher(file, session);
                        ** break;
lbl40:
                        // 1 sources

                    }
                    catch (IOException io) {
                        DefaultSystemLog.ERROR().error("\u76d1\u542c\u65e5\u5fd7\u53d8\u5316", (Throwable)io);
                        SocketSessionUtil.send((Session)session, (String)io.getMessage());
                        ** break;
                    }
lbl45:
                    // 1 sources

                    break;
                }
                default: {
                    resultData = JsonMessage.toJson((int)404, (String)("\u4e0d\u652f\u6301\u7684\u65b9\u5f0f\uff1a" + consoleCommandOp.name()));
                    break;
                }
            }
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u6267\u884c\u547d\u4ee4\u5931\u8d25", (Throwable)e);
            SocketSessionUtil.send((Session)session, (String)"\u6267\u884c\u547d\u4ee4\u5931\u8d25,\u8be6\u60c5\u5982\u4e0b\uff1a");
            SocketSessionUtil.send((Session)session, (String)ExceptionUtil.stacktraceToString((Throwable)e));
            return;
        }
        finally {
            if (logUser) {
                newProjectInfoModel = (ProjectInfoModel)AgentWebSocketConsoleHandle.projectInfoService.getItem(projectInfoModel.getId());
                name = this.getOptUserName(session);
                newProjectInfoModel.setModifyUser(name);
                AgentWebSocketConsoleHandle.projectInfoService.updateItem(newProjectInfoModel);
            }
        }
        if (resultData != null) {
            reqJson.putAll((Map)resultData);
            DefaultSystemLog.LOG().info(reqJson.toString());
            SocketSessionUtil.send((Session)session, (String)reqJson.toString());
        }
    }

    @Override
    @OnClose
    public void onClose(Session session) {
        super.onClose(session);
    }

    @Override
    @OnError
    public void onError(Session session, Throwable thr) {
        super.onError(session, thr);
    }
}

