/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.socket;

import cn.hutool.core.io.FileUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import io.jpom.util.BaseFileTailWatcher;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Session;

public class AgentFileTailWatcher<T>
extends BaseFileTailWatcher<T> {
    private static final ConcurrentHashMap<File, AgentFileTailWatcher<Session>> CONCURRENT_HASH_MAP = new ConcurrentHashMap();

    private AgentFileTailWatcher(File logFile) throws IOException {
        super(logFile);
    }

    public static int getOneLineCount() {
        return CONCURRENT_HASH_MAP.size();
    }

    public static void addWatcher(File file, Session session) throws IOException {
        if (!file.exists() || file.isDirectory()) {
            throw new IOException("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u8005\u662f\u76ee\u5f55:" + file.getPath());
        }
        AgentFileTailWatcher agentFileTailWatcher = CONCURRENT_HASH_MAP.computeIfAbsent(file, s -> {
            try {
                return new AgentFileTailWatcher(file);
            }
            catch (Exception e) {
                DefaultSystemLog.ERROR().error("\u521b\u5efa\u6587\u4ef6\u76d1\u542c\u5931\u8d25", (Throwable)e);
                return null;
            }
        });
        if (agentFileTailWatcher == null) {
            throw new IOException("\u52a0\u8f7d\u6587\u4ef6\u5931\u8d25:" + file.getPath());
        }
        agentFileTailWatcher.add(session, FileUtil.getName((File)file));
        agentFileTailWatcher.tailWatcherRun.start();
    }

    public static void offline(Session session) {
        Collection<AgentFileTailWatcher<Session>> collection = CONCURRENT_HASH_MAP.values();
        for (AgentFileTailWatcher<Session> agentFileTailWatcher : collection) {
            agentFileTailWatcher.socketSessions.removeIf(session::equals);
            if (!agentFileTailWatcher.socketSessions.isEmpty()) continue;
            agentFileTailWatcher.close();
        }
    }

    public static void offlineFile(File fileName) {
        AgentFileTailWatcher<Session> agentFileTailWatcher = CONCURRENT_HASH_MAP.get(fileName);
        if (null == agentFileTailWatcher) {
            return;
        }
        Set socketSessions = agentFileTailWatcher.socketSessions;
        for (Session socketSession : socketSessions) {
            AgentFileTailWatcher.offline(socketSession);
        }
        agentFileTailWatcher.close();
    }

    static void offlineFile(File fileName, Session session) {
        AgentFileTailWatcher<Session> agentFileTailWatcher = CONCURRENT_HASH_MAP.get(fileName);
        if (null == agentFileTailWatcher) {
            return;
        }
        Set socketSessions = agentFileTailWatcher.socketSessions;
        for (Session socketSession : socketSessions) {
            if (!socketSession.equals(session)) continue;
            AgentFileTailWatcher.offline(socketSession);
            break;
        }
        if (agentFileTailWatcher.socketSessions.isEmpty()) {
            agentFileTailWatcher.close();
        }
    }

    protected void close() {
        super.close();
        CONCURRENT_HASH_MAP.remove(this.logFile);
    }
}

