/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.service.system;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.odiszapc.nginxparser.NgxBlock;
import com.github.odiszapc.nginxparser.NgxConfig;
import com.github.odiszapc.nginxparser.NgxEntry;
import com.github.odiszapc.nginxparser.NgxParam;
import io.jpom.common.BaseDataService;
import io.jpom.model.data.AgentWhitelist;
import io.jpom.service.WhitelistDirectoryService;
import io.jpom.util.JsonFileUtil;
import io.jpom.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class NginxService
extends BaseDataService {
    @Resource
    private WhitelistDirectoryService whitelistDirectoryService;

    public JSONArray list() {
        AgentWhitelist agentWhitelist = this.whitelistDirectoryService.getWhitelist();
        if (agentWhitelist == null) {
            return null;
        }
        List ngxDirectory = agentWhitelist.getNginx();
        if (ngxDirectory == null) {
            return null;
        }
        JSONArray array = new JSONArray();
        for (Object o : ngxDirectory) {
            String parentPath = o.toString();
            File whiteDir = new File(parentPath);
            if (!whiteDir.isDirectory()) continue;
            List list = null;
            try {
                list = FileUtil.loopFiles((File)whiteDir, pathname -> pathname.getName().endsWith(".conf"));
            }
            catch (Exception e) {
                DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
            }
            if (list == null || list.size() <= 0) continue;
            String absPath = whiteDir.getAbsolutePath();
            for (File itemFile : list) {
                String name = StringUtil.delStartPath((File)itemFile, (String)absPath, (boolean)true);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("path", (Object)parentPath);
                jsonObject.put("name", (Object)name);
                long time = itemFile.lastModified();
                jsonObject.put("time", (Object)DateUtil.date((long)time).toString());
                try {
                    NgxConfig config = NgxConfig.read((String)itemFile.getPath());
                    List server = config.findAll(NgxBlock.class, new String[]{"server"});
                    JSONObject data = this.findSeverName(server);
                    if (data != null) {
                        jsonObject.putAll((Map)data);
                    }
                }
                catch (IOException e) {
                    DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
                }
                array.add((Object)jsonObject);
            }
        }
        return array;
    }

    private JSONObject findSeverName(List<NgxEntry> server) {
        if (null == server) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        HashSet<String> serverNames = new HashSet<String>();
        HashSet location = new HashSet();
        HashSet<String> listen = new HashSet<String>();
        for (NgxEntry ngxEntry : server) {
            NgxParam listenParm;
            List locationAll;
            NgxBlock ngxBlock = (NgxBlock)ngxEntry;
            NgxParam serverName = ngxBlock.findParam(new String[]{"server_name"});
            if (null != serverName) {
                serverNames.add(serverName.getValue());
            }
            if ((locationAll = ngxBlock.findAll(NgxBlock.class, new String[]{"location"})) != null) {
                locationAll.forEach(ngxEntry1 -> {
                    NgxBlock ngxBlock1 = (NgxBlock)ngxEntry1;
                    if (!"/".equals(ngxBlock1.getValue())) {
                        return;
                    }
                    NgxParam locationMain = ngxBlock1.findParam(new String[]{"proxy_pass"});
                    if (locationMain == null) {
                        locationMain = ngxBlock1.findParam(new String[]{"root"});
                    }
                    if (locationMain == null) {
                        locationMain = ngxBlock1.findParam(new String[]{"alias"});
                    }
                    location.add(locationMain.getValue());
                });
            }
            if ((listenParm = ngxBlock.findParam(new String[]{"listen"})) == null) continue;
            listen.add(listenParm.getValue());
        }
        jsonObject.put("serverCount", (Object)server.size());
        jsonObject.put("server_name", (Object)CollUtil.join(serverNames, (CharSequence)","));
        jsonObject.put("location", (Object)CollUtil.join(location, (CharSequence)","));
        jsonObject.put("listen", (Object)CollUtil.join(listen, (CharSequence)","));
        return jsonObject;
    }

    public JSONObject getItem(String path) {
        JSONObject jsonObject = new JSONObject();
        try {
            List list;
            NgxConfig conf = NgxConfig.read((String)path);
            NgxParam cache = conf.findParam(new String[]{"http", "proxy_cache_path"});
            if (cache != null) {
                String value = cache.getValue();
                String[] split = value.split(" ");
                jsonObject.put("cachePath", (Object)split[0].trim());
                String maxSize = split[3];
                String size = maxSize.substring("max_size=".length(), maxSize.length() - 1);
                jsonObject.put("cacheSize", (Object)size);
                String inactive = split[4];
                String time = inactive.substring("inactive=".length(), inactive.length() - 1);
                jsonObject.put("inactive", (Object)time);
            }
            if ((list = conf.findAll(NgxBlock.class, new String[]{"server"})) == null) {
                return jsonObject;
            }
            boolean main = true;
            for (NgxEntry ngxEntry : list) {
                NgxParam rewrite;
                NgxBlock block = (NgxBlock)ngxEntry;
                NgxParam certificate = block.findParam(new String[]{"ssl_certificate"});
                NgxParam key = block.findParam(new String[]{"ssl_certificate_key"});
                NgxParam listen = block.findParam(new String[]{"listen"});
                NgxParam serverName = block.findParam(new String[]{"server_name"});
                NgxParam location = block.findParam(new String[]{"location", "proxy_pass"});
                if (certificate != null && main) {
                    main = false;
                    jsonObject.put("cert", (Object)certificate.getValue());
                    jsonObject.put("key", (Object)key.getValue());
                    jsonObject.put("port", (Object)listen.getValue());
                    jsonObject.put("domain", (Object)serverName.getValue());
                    jsonObject.put("location", (Object)location.getValue());
                }
                if ((rewrite = block.findParam(new String[]{"rewrite"})) != null) {
                    jsonObject.put("convert", (Object)true);
                }
                if (!main) continue;
                jsonObject.put("port", (Object)listen.getValue());
                jsonObject.put("domain", (Object)serverName.getValue());
                if (null == location) continue;
                jsonObject.put("location", (Object)location.getValue());
            }
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
        }
        return jsonObject;
    }

    public JSONObject getNgxConf() {
        JSONObject object = this.getJSONObject("nginx_conf.json");
        if (object == null) {
            object = new JSONObject();
            object.put("name", (Object)"nginx");
            this.save(object);
        }
        return object;
    }

    public void save(JSONObject object) {
        String dataFilePath = this.getDataFilePath("nginx_conf.json");
        JsonFileUtil.saveJson((String)dataFilePath, (JSON)object);
    }
}

