/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.service.script;

import cn.hutool.core.io.FileUtil;
import io.jpom.common.BaseOperService;
import io.jpom.model.BaseModel;
import io.jpom.model.data.ScriptModel;
import java.io.File;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ScriptServer
extends BaseOperService<ScriptModel> {
    public ScriptServer() {
        super("script.json");
    }

    public List<ScriptModel> list() {
        List scriptModels = super.list();
        if (scriptModels == null) {
            return null;
        }
        scriptModels.forEach(ScriptModel::readFileTime);
        return scriptModels;
    }

    public ScriptModel getItem(String id) {
        ScriptModel scriptModel = (ScriptModel)super.getItem(id);
        if (scriptModel != null) {
            scriptModel.readFileContext();
        }
        return scriptModel;
    }

    public void addItem(ScriptModel scriptModel) {
        super.addItem((BaseModel)scriptModel);
        scriptModel.saveFile();
    }

    public void updateItem(ScriptModel scriptModel) {
        super.updateItem((BaseModel)scriptModel);
        scriptModel.saveFile();
    }

    public void deleteItem(String id) {
        ScriptModel scriptModel = this.getItem(id);
        if (scriptModel != null) {
            FileUtil.del((File)scriptModel.getFile(true).getParentFile());
        }
        super.deleteItem(id);
    }
}

