/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.service.manage;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.jiangzeyin.common.JsonMessage;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.jpom.controller.tomcat.TomcatOp;
import io.jpom.model.data.TomcatInfoModel;
import io.jpom.service.manage.TomcatEditService;
import io.jpom.system.JpomRuntimeException;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TomcatManageService {
    @Resource
    private TomcatEditService tomcatEditService;

    public int getTomcatStatus(String id) {
        int result = 0;
        TomcatInfoModel tomcatInfoModel = (TomcatInfoModel)this.tomcatEditService.getItem(id);
        String url = String.format("http://127.0.0.1:%d/", tomcatInfoModel.getPort());
        HttpRequest httpRequest = new HttpRequest(url);
        httpRequest.setConnectionTimeout(3000);
        try {
            HttpResponse httpResponse = httpRequest.execute();
            result = 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public JSONArray getTomcatProjectList(String id) {
        TomcatInfoModel tomcatInfoModel = (TomcatInfoModel)this.tomcatEditService.getItem(id);
        String body = this.tomcatCmd(tomcatInfoModel, "text/list");
        String[] result = body.replace("\r\n", "$").replace("\n", "$").split("\\$");
        JSONArray jsonArray = new JSONArray();
        for (int i = 1; i < result.length; ++i) {
            String str = result[i];
            JSONObject jsonObject = new JSONObject();
            String[] strs = str.split(":");
            if (strs[0].endsWith("jpomAgent")) continue;
            jsonObject.put("path", (Object)("/".equals(strs[0]) ? "/ROOT" : strs[0]));
            jsonObject.put("status", (Object)strs[1]);
            jsonObject.put("session", (Object)strs[2]);
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    private String tomcatCmd(TomcatInfoModel tomcatInfoModel, String cmd) {
        String url = String.format("http://127.0.0.1:%d/jpomAgent/%s", tomcatInfoModel.getPort(), cmd);
        HttpRequest httpRequest = new HttpRequest(url);
        httpRequest.setConnectionTimeout(3000);
        String body = "";
        try {
            HttpResponse httpResponse = httpRequest.execute();
            if (httpResponse.isOk()) {
                body = httpResponse.body();
            }
            if (httpResponse.getStatus() == 404) {
                tomcatInfoModel.initTomcat();
                throw new JpomRuntimeException("tomcat \u672a\u521d\u59cb\u5316\uff0c\u5df2\u7ecf\u91cd\u65b0\u521d\u59cb\u5316\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        catch (JpomRuntimeException jpom) {
            throw jpom;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return body;
    }

    public JsonMessage tomcatProjectManage(String id, String path, TomcatOp tomcatOp) {
        TomcatInfoModel tomcatInfoModel = (TomcatInfoModel)this.tomcatEditService.getItem(id);
        String result = this.tomcatCmd(tomcatInfoModel, String.format("text/%s?path=%s", tomcatOp.name(), path));
        if (result.startsWith("OK")) {
            return new JsonMessage(200, "\u64cd\u4f5c\u6210\u529f");
        }
        return new JsonMessage(500, "\u64cd\u4f5c\u5931\u8d25:" + result);
    }
}

