/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.service.manage;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import io.jpom.common.BaseAgentController;
import io.jpom.common.BaseOperService;
import io.jpom.model.BaseModel;
import io.jpom.model.data.ProjectInfoModel;
import io.jpom.model.data.ProjectRecoverModel;
import io.jpom.service.manage.ProjectRecoverService;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ProjectInfoService
extends BaseOperService<ProjectInfoModel> {
    @Resource
    private ProjectRecoverService projectRecoverService;

    public ProjectInfoService() {
        super("project.json");
    }

    public HashSet<String> getAllGroup() {
        List projectInfoModels = this.list();
        HashSet<String> hashSet = new HashSet<String>();
        if (projectInfoModels == null) {
            return hashSet;
        }
        for (ProjectInfoModel projectInfoModel : projectInfoModels) {
            hashSet.add(projectInfoModel.getGroup());
        }
        return hashSet;
    }

    public void deleteItem(String id) {
        ProjectInfoModel projectInfo = (ProjectInfoModel)this.getItem(id);
        String userId = BaseAgentController.getNowUserName();
        super.deleteItem(id);
        ProjectRecoverModel projectRecoverModel = new ProjectRecoverModel(projectInfo);
        projectRecoverModel.setDelUser(userId);
        this.projectRecoverService.addItem(projectRecoverModel);
    }

    public void updateItem(ProjectInfoModel projectInfo) {
        projectInfo.setModifyTime(DateUtil.now());
        super.updateItem((BaseModel)projectInfo);
    }

    public String getLogSize(String id) {
        ProjectInfoModel pim = (ProjectInfoModel)this.getItem(id);
        if (pim == null) {
            return null;
        }
        String logSize = null;
        File file = new File(pim.getLog());
        if (file.exists()) {
            long fileSize = file.length();
            if (fileSize <= 0L) {
                return null;
            }
            logSize = FileUtil.readableFileSize((long)fileSize);
        }
        return logSize;
    }
}

