/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.service;

import cn.jiangzeyin.common.DefaultSystemLog;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.jpom.common.BaseDataService;
import io.jpom.model.data.AgentWhitelist;
import io.jpom.util.JsonFileUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class WhitelistDirectoryService
extends BaseDataService {
    public AgentWhitelist getWhitelist() {
        try {
            JSONObject jsonObject = this.getJSONObject("whitelistDirectory.json");
            if (jsonObject == null) {
                return null;
            }
            return (AgentWhitelist)jsonObject.toJavaObject(AgentWhitelist.class);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void addProjectWhiteList(String item) {
        ArrayList<String> project;
        AgentWhitelist agentWhitelist = this.getWhitelist();
        if (agentWhitelist == null) {
            agentWhitelist = new AgentWhitelist();
        }
        if ((project = agentWhitelist.getProject()) == null) {
            project = new ArrayList<String>();
        }
        project.add(item);
        this.saveWhitelistDirectory(agentWhitelist);
    }

    public boolean isInstalled() {
        AgentWhitelist agentWhitelist = this.getWhitelist();
        if (agentWhitelist == null) {
            return false;
        }
        List project = agentWhitelist.getProject();
        return project != null && !project.isEmpty();
    }

    private List<String> getNgxDirectory() {
        AgentWhitelist agentWhitelist = this.getWhitelist();
        if (agentWhitelist == null) {
            return null;
        }
        return agentWhitelist.getNginx();
    }

    public boolean checkProjectDirectory(String path) {
        AgentWhitelist agentWhitelist = this.getWhitelist();
        if (agentWhitelist == null) {
            return false;
        }
        List list = agentWhitelist.getProject();
        return AgentWhitelist.checkPath((List)list, (String)path);
    }

    public boolean checkNgxDirectory(String path) {
        List<String> list = this.getNgxDirectory();
        return AgentWhitelist.checkPath(list, (String)path);
    }

    private List<String> getCertificateDirectory() {
        AgentWhitelist agentWhitelist = this.getWhitelist();
        if (agentWhitelist == null) {
            return null;
        }
        return agentWhitelist.getCertificate();
    }

    public boolean checkCertificateDirectory(String path) {
        List<String> list = this.getCertificateDirectory();
        if (list == null) {
            return false;
        }
        return AgentWhitelist.checkPath(list, (String)path);
    }

    public void saveWhitelistDirectory(AgentWhitelist jsonObject) {
        String path = this.getDataFilePath("whitelistDirectory.json");
        JsonFileUtil.saveJson((String)path, (JSON)jsonObject.toJson());
    }
}

