/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.model.data;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import io.jpom.model.BaseModel;
import io.jpom.system.JpomRuntimeException;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;

public class TomcatInfoModel
extends BaseModel {
    private String path;
    private int port;
    private int status;
    private String appBase;
    private String creator;
    private String createTime;
    private String modifyUser;
    private String modifyTime;

    public String getPath() {
        if (this.path == null) {
            return null;
        }
        return FileUtil.normalize((String)(this.path + "/"));
    }

    public String pathAndCheck() {
        String path = this.getPath();
        if (path == null) {
            return null;
        }
        if (TomcatInfoModel.isTomcatRoot(path)) {
            return path;
        }
        throw new RuntimeException(String.format("\u6ca1\u6709\u5728\u8def\u5f84\uff1a%s \u4e0b\u68c0\u6d4b\u5230Tomcat", path));
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getAppBase() {
        if (StrUtil.isEmpty((CharSequence)this.appBase)) {
            return "";
        }
        return FileUtil.normalize((String)(this.appBase + "/"));
    }

    public void setAppBase(String appBase) {
        this.appBase = appBase;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getModifyUser() {
        return this.modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public String getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(String modifyTime) {
        this.modifyTime = modifyTime;
    }

    private static boolean isTomcatRoot(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return false;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return false;
        }
        for (File child : files) {
            if (!"bin".equals(child.getName()) || !child.isDirectory()) continue;
            File[] binFiles = child.listFiles();
            if (binFiles == null) {
                return false;
            }
            for (File binChild : binFiles) {
                if (!"bootstrap.jar".equals(binChild.getName()) || !binChild.isFile()) continue;
                return true;
            }
        }
        return false;
    }

    public void initTomcat() {
        String tomcatPath = this.pathAndCheck();
        String appBase = this.getAppBase();
        if (StrUtil.isEmpty((CharSequence)appBase) || "/".equals(appBase)) {
            File webapps = FileUtil.file((String)tomcatPath, (String)"webapps");
            this.setAppBase(webapps.getAbsolutePath());
        } else {
            String path = FileUtil.normalize((String)appBase);
            if (FileUtil.isAbsolutePath((String)path)) {
                this.setAppBase(path);
            } else {
                File webapps = FileUtil.file((String)tomcatPath, (String)path);
                this.setAppBase(webapps.getAbsolutePath());
            }
        }
        InputStream inputStream = ResourceUtil.getStream((String)"classpath:/bin/jpomAgent.zip");
        if (inputStream == null) {
            throw new JpomRuntimeException("jpomAgent.zip\u4e0d\u5b58\u5728");
        }
        ZipUtil.unzip((InputStream)inputStream, (File)new File(this.getAppBase()), (Charset)CharsetUtil.CHARSET_UTF_8);
    }
}

