/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.model.data;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import io.jpom.model.BaseModel;
import io.jpom.system.AgentConfigBean;
import io.jpom.util.CommandUtil;
import java.io.File;
import java.nio.charset.Charset;

public class ScriptModel
extends BaseModel {
    private String lastRunUser;
    private String modifyTime;
    private String context;

    public String getLastRunUser() {
        return StrUtil.emptyToDefault((CharSequence)this.lastRunUser, (String)"-");
    }

    public void setLastRunUser(String lastRunUser) {
        this.lastRunUser = lastRunUser;
    }

    public String getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(String modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public File getFile(boolean get) {
        if (StrUtil.isEmpty((CharSequence)this.getId())) {
            throw new IllegalArgumentException("id \u4e3a\u7a7a");
        }
        File path = AgentConfigBean.getInstance().getScriptPath();
        return FileUtil.file((File)path, (String[])new String[]{this.getId(), "script." + CommandUtil.SUFFIX});
    }

    public File getLogFile(boolean get) {
        File logFile;
        if (StrUtil.isEmpty((CharSequence)this.getId())) {
            throw new IllegalArgumentException("id \u4e3a\u7a7a");
        }
        File path = AgentConfigBean.getInstance().getScriptPath();
        int count = 0;
        do {
            String now = DateTime.now().toString("yyyyMMddHHmmss");
            logFile = FileUtil.file((File)path, (String[])new String[]{this.getId(), "log", now + count + ".log"});
            ++count;
        } while (FileUtil.exist((File)logFile));
        return logFile;
    }

    public void saveFile() {
        File file = this.getFile(true);
        FileUtil.writeString((String)this.getContext(), (File)file, (Charset)CharsetUtil.CHARSET_UTF_8);
        if (SystemUtil.getOsInfo().isLinux()) {
            CommandUtil.execCommand((String)("chmod 755 " + FileUtil.getAbsolutePath((File)file)));
        }
    }

    public void readFileTime() {
        File file = this.getFile(true);
        long lastModified = file.lastModified();
        this.setModifyTime(DateUtil.date((long)lastModified).toString());
    }

    public void readFileContext() {
        File file = this.getFile(true);
        if (FileUtil.exist((File)file)) {
            String context = FileUtil.readString((File)file, (Charset)CharsetUtil.CHARSET_UTF_8);
            this.setContext(context);
        }
    }
}

