/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.model.data;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.spring.SpringUtil;
import io.jpom.common.commander.AbstractProjectCommander;
import io.jpom.model.BaseModel;
import io.jpom.model.RunMode;
import io.jpom.service.WhitelistDirectoryService;
import io.jpom.system.JpomRuntimeException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ProjectInfoModel
extends BaseModel {
    private String group;
    private String mainClass;
    private String lib;
    private String whitelistDirectory;
    private String log;
    private String jvm;
    private String token;
    private boolean status;
    private String createTime;
    private String modifyTime;
    private String args;
    private String useLibDesc;
    private String runLibDesc;
    private String modifyUser;
    private RunMode runMode;
    private boolean outGivingProject;
    private String runCommand;

    public String getRunCommand() {
        return this.runCommand;
    }

    public void setRunCommand(String runCommand) {
        this.runCommand = runCommand;
    }

    public boolean isOutGivingProject() {
        return this.outGivingProject;
    }

    public void setOutGivingProject(boolean outGivingProject) {
        this.outGivingProject = outGivingProject;
    }

    public RunMode getRunMode() {
        if (this.runMode == null) {
            return RunMode.ClassPath;
        }
        return this.runMode;
    }

    public void setRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    public String getModifyUser() {
        if (StrUtil.isEmpty((CharSequence)this.modifyUser)) {
            return "-";
        }
        return this.modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public boolean isStatus(boolean get) {
        try {
            this.status = AbstractProjectCommander.getInstance().isRun(this.getId());
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u68c0\u67e5\u9879\u76ee\u72b6\u6001\u9519\u8bef", (Throwable)e);
            this.status = false;
        }
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getRunLibDesc() {
        return this.runLibDesc;
    }

    public void setRunLibDesc(String runLibDesc) {
        this.runLibDesc = runLibDesc;
    }

    public String getUseLibDesc() {
        return this.useLibDesc;
    }

    public void setUseLibDesc(String useLibDesc) {
        this.useLibDesc = useLibDesc;
    }

    public String getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(String modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getJvm() {
        return StrUtil.emptyToDefault((CharSequence)this.jvm, (String)"");
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public String getGroup() {
        if (StrUtil.isEmpty((CharSequence)this.group)) {
            return "\u9ed8\u8ba4";
        }
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getMainClass() {
        return StrUtil.emptyToDefault((CharSequence)this.mainClass, (String)"");
    }

    private void repairWhitelist() {
        if (StrUtil.isEmpty((CharSequence)this.whitelistDirectory) && StrUtil.isEmpty((CharSequence)this.lib)) {
            throw new JpomRuntimeException("\u5f53\u524d\u9879\u76eelib\u6570\u636e\u5f02\u5e38");
        }
        if (StrUtil.isNotEmpty((CharSequence)this.whitelistDirectory)) {
            return;
        }
        WhitelistDirectoryService whitelistDirectoryService = (WhitelistDirectoryService)((Object)SpringUtil.getBean(WhitelistDirectoryService.class));
        List project = whitelistDirectoryService.getWhitelist().getProject();
        for (String path : project) {
            if (!this.lib.startsWith(path)) continue;
            String itemWhitelistDirectory = this.lib.substring(0, path.length());
            this.lib = this.lib.substring(path.length());
            this.setWhitelistDirectory(itemWhitelistDirectory);
            this.setLib(this.lib);
        }
    }

    public String getWhitelistDirectory() {
        this.repairWhitelist();
        if (StrUtil.isEmpty((CharSequence)this.whitelistDirectory)) {
            throw new JpomRuntimeException("\u4fee\u62a4\u767d\u540d\u5355\u6570\u636e\u5f02\u5e38");
        }
        return this.whitelistDirectory;
    }

    public void setWhitelistDirectory(String whitelistDirectory) {
        this.whitelistDirectory = whitelistDirectory;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getLib() {
        this.repairWhitelist();
        return this.lib;
    }

    public String allLib() {
        return FileUtil.file((String)this.getWhitelistDirectory(), (String)this.getLib()).getAbsolutePath();
    }

    public static List<File> listJars(ProjectInfoModel projectInfoModel) {
        File fileLib = new File(projectInfoModel.allLib());
        File[] files = fileLib.listFiles();
        ArrayList<File> files1 = new ArrayList<File>();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !StrUtil.endWith((CharSequence)file.getName(), (CharSequence)".jar", (boolean)true)) continue;
                files1.add(file);
            }
        }
        return files1;
    }

    public static String getClassPathLib(ProjectInfoModel projectInfoModel) {
        List<File> files = ProjectInfoModel.listJars(projectInfoModel);
        if (files == null || files.size() <= 0) {
            return "";
        }
        StringBuilder classPath = new StringBuilder();
        RunMode runMode = projectInfoModel.getRunMode();
        int len = files.size();
        if (runMode == RunMode.ClassPath) {
            classPath.append("-classpath ");
        } else if (runMode == RunMode.Jar) {
            classPath.append("-jar ");
            len = 1;
        }
        for (int i = 0; i < len; ++i) {
            File file = files.get(i);
            classPath.append(file.getAbsolutePath());
            if (i == len - 1) continue;
            classPath.append(SystemUtil.getOsInfo().isWindows() ? ";" : ":");
        }
        return classPath.toString();
    }

    public void setLib(String lib) {
        this.lib = lib;
    }

    public String getLog() {
        return StrUtil.emptyToDefault((CharSequence)this.log, (String)"");
    }

    public String getAbsoluteLog() {
        File file = new File(this.getLog());
        return file.getAbsolutePath();
    }

    public File getLogBack() {
        return new File(this.getLog() + "_back");
    }

    public void setLog(String log) {
        this.log = log;
    }

    public String getToken() {
        if ("no".equalsIgnoreCase(this.token)) {
            return "";
        }
        return StrUtil.emptyToDefault((CharSequence)this.token, (String)"");
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getArgs() {
        return StrUtil.emptyToDefault((CharSequence)this.args, (String)"");
    }

    public void setArgs(String args) {
        this.args = args;
    }
}

