/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.model.data;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import io.jpom.model.BaseModel;
import io.jpom.service.system.CertService;
import io.jpom.system.JpomRuntimeException;
import java.io.Closeable;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;

public class CertModel
extends BaseModel {
    private static final String KEY = "Jpom \u7ba1\u7406\u7cfb\u7edf";
    private String cert;
    private String key;
    private long expirationTime;
    private long effectiveTime;
    private String domain;
    private String whitePath;
    private Type type;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getWhitePath() {
        return this.whitePath;
    }

    public void setWhitePath(String whitePath) {
        this.whitePath = whitePath;
    }

    public String getCert() {
        return this.cert;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getExpirationTime() {
        this.convertInfo();
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getDomain() {
        this.convertInfo();
        return this.domain;
    }

    private void convertInfo() {
        if (!StrUtil.isEmpty((CharSequence)this.domain)) {
            return;
        }
        JSONObject jsonObject = CertModel.decodeCert(this.getCert(), this.getKey());
        if (jsonObject != null) {
            this.setDomain(jsonObject.getString("domain"));
            this.setExpirationTime(jsonObject.getLongValue("expirationTime"));
            this.setEffectiveTime(jsonObject.getLongValue("effectiveTime"));
            CertService certService = (CertService)((Object)SpringUtil.getBean(CertService.class));
            certService.updateItem(this);
        }
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public long getEffectiveTime() {
        this.convertInfo();
        return this.effectiveTime;
    }

    public void setEffectiveTime(long effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject decodeCert(String file, String key) {
        if (file == null) {
            return null;
        }
        if (!FileUtil.exist((String)file)) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = ResourceUtil.getStream((String)key);
            PrivateKey privateKey = BCUtil.readPrivateKey((InputStream)inputStream);
            IoUtil.close((Closeable)inputStream);
            inputStream = ResourceUtil.getStream((String)file);
            PublicKey publicKey = BCUtil.readPublicKey((InputStream)inputStream);
            IoUtil.close((Closeable)inputStream);
            RSA rsa = new RSA(privateKey, publicKey);
            String encryptStr = rsa.encryptBase64(KEY, KeyType.PublicKey);
            String decryptStr = rsa.decryptStr(encryptStr, KeyType.PrivateKey);
            if (!KEY.equals(decryptStr)) {
                throw new JpomRuntimeException("\u8bc1\u4e66\u548c\u79c1\u94a5\u8bc1\u4e66\u4e0d\u5339\u914d");
            }
        }
        finally {
            IoUtil.close((Closeable)inputStream);
        }
        try {
            inputStream = ResourceUtil.getStream((String)file);
            X509Certificate oCert = (X509Certificate)KeyUtil.readX509Certificate((InputStream)inputStream);
            Date expirationTime = oCert.getNotAfter();
            Date effectiveTime = oCert.getNotBefore();
            String name = oCert.getSubjectDN().getName();
            int i = name.indexOf("=");
            String domain = name.substring(i + 1);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("expirationTime", (Object)expirationTime.getTime());
            jsonObject.put("effectiveTime", (Object)effectiveTime.getTime());
            jsonObject.put("domain", (Object)domain);
            jsonObject.put("pemPath", (Object)file);
            jsonObject.put("keyPath", (Object)key);
            JSONObject jSONObject = jsonObject;
            return jSONObject;
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
        }
        finally {
            IoUtil.close((Closeable)inputStream);
        }
        return null;
    }

    public static enum Type {
        pem,
        cer,
        crt;

    }
}

